/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc.lifecycle;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.apache.camel.component.pqc.lifecycle.KeyLifecycleManager;

public class KeyFormatConverter {
    public static byte[] exportPublicKey(PublicKey publicKey, KeyLifecycleManager.KeyFormat format) throws Exception {
        switch (format) {
            case PEM: {
                return KeyFormatConverter.exportPublicKeyToPEM(publicKey);
            }
            case DER: 
            case X509: {
                return publicKey.getEncoded();
            }
        }
        throw new IllegalArgumentException("Unsupported format for public key: " + String.valueOf((Object)format));
    }

    public static byte[] exportPrivateKey(PrivateKey privateKey, KeyLifecycleManager.KeyFormat format) throws Exception {
        switch (format) {
            case PEM: {
                return KeyFormatConverter.exportPrivateKeyToPEM(privateKey);
            }
            case DER: 
            case PKCS8: {
                return privateKey.getEncoded();
            }
        }
        throw new IllegalArgumentException("Unsupported format for private key: " + String.valueOf((Object)format));
    }

    public static byte[] exportKeyPair(KeyPair keyPair, KeyLifecycleManager.KeyFormat format, boolean includePrivate) throws Exception {
        if (includePrivate) {
            byte[] publicKeyBytes = KeyFormatConverter.exportPublicKey(keyPair.getPublic(), format);
            byte[] privateKeyBytes = KeyFormatConverter.exportPrivateKey(keyPair.getPrivate(), format);
            if (format == KeyLifecycleManager.KeyFormat.PEM) {
                return (new String(publicKeyBytes) + "\n" + new String(privateKeyBytes)).getBytes();
            }
            return privateKeyBytes;
        }
        return KeyFormatConverter.exportPublicKey(keyPair.getPublic(), format);
    }

    public static PublicKey importPublicKey(byte[] keyData, KeyLifecycleManager.KeyFormat format, String algorithm) throws Exception {
        byte[] derBytes = format == KeyLifecycleManager.KeyFormat.PEM ? KeyFormatConverter.parsePEMPublicKey(keyData) : keyData;
        X509EncodedKeySpec spec = new X509EncodedKeySpec(derBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(spec);
    }

    public static PrivateKey importPrivateKey(byte[] keyData, KeyLifecycleManager.KeyFormat format, String algorithm) throws Exception {
        byte[] derBytes = format == KeyLifecycleManager.KeyFormat.PEM ? KeyFormatConverter.parsePEMPrivateKey(keyData) : keyData;
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(derBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(spec);
    }

    private static byte[] exportPublicKeyToPEM(PublicKey publicKey) throws Exception {
        byte[] encoded = publicKey.getEncoded();
        String base64 = Base64.getEncoder().encodeToString(encoded);
        StringBuilder pem = new StringBuilder();
        pem.append("-----BEGIN PUBLIC KEY-----\n");
        for (int i = 0; i < base64.length(); i += 64) {
            pem.append(base64, i, Math.min(i + 64, base64.length())).append("\n");
        }
        pem.append("-----END PUBLIC KEY-----\n");
        return pem.toString().getBytes();
    }

    private static byte[] exportPrivateKeyToPEM(PrivateKey privateKey) throws Exception {
        byte[] encoded = privateKey.getEncoded();
        String base64 = Base64.getEncoder().encodeToString(encoded);
        StringBuilder pem = new StringBuilder();
        pem.append("-----BEGIN PRIVATE KEY-----\n");
        for (int i = 0; i < base64.length(); i += 64) {
            pem.append(base64, i, Math.min(i + 64, base64.length())).append("\n");
        }
        pem.append("-----END PRIVATE KEY-----\n");
        return pem.toString().getBytes();
    }

    private static byte[] parsePEMPublicKey(byte[] pemData) throws Exception {
        String pemString = new String(pemData);
        pemString = pemString.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "");
        return Base64.getDecoder().decode(pemString);
    }

    private static byte[] parsePEMPrivateKey(byte[] pemData) throws Exception {
        String pemString = new String(pemData);
        pemString = pemString.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s", "");
        return Base64.getDecoder().decode(pemString);
    }
}

