/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc.dataformat;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import org.apache.camel.Exchange;
import org.apache.camel.component.pqc.PQCKeyEncapsulationAlgorithms;
import org.apache.camel.component.pqc.PQCSymmetricAlgorithms;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.builder.OutputStreamBuilder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import org.bouncycastle.jcajce.spec.KEMExtractSpec;
import org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="pqc")
public class PQCDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    public static final String KEY_PAIR = "CamelPQCKeyPair";
    public static final String KEM_ALGORITHM = "CamelPQCKemAlgorithm";
    public static final String SYMMETRIC_ALGORITHM = "CamelPQCSymmetricAlgorithm";
    private static final Logger LOG = LoggerFactory.getLogger(PQCDataFormat.class);
    private String keyEncapsulationAlgorithm = "MLKEM";
    private String symmetricKeyAlgorithm = "AES";
    private int symmetricKeyLength = 128;
    private KeyPair keyPair;
    private int bufferSize = 4096;
    private String provider;
    private KeyGenerator keyGenerator;

    public PQCDataFormat() {
    }

    public PQCDataFormat(String keyEncapsulationAlgorithm, String symmetricKeyAlgorithm, KeyPair keyPair) {
        this.keyEncapsulationAlgorithm = keyEncapsulationAlgorithm;
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
        this.keyPair = keyPair;
    }

    public String getDataFormatName() {
        return "pqc";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        KeyPair kp = this.getKeyPair(exchange);
        if (kp == null || kp.getPublic() == null) {
            throw new IllegalStateException("A valid KeyPair with public key is required for encryption. Either configure the PQCDataFormat with a KeyPair or provide one in a header using 'CamelPQCKeyPair'");
        }
        String kemAlg = this.getKemAlgorithm(exchange);
        String symAlg = this.getSymmetricAlgorithm(exchange);
        InputStream plaintextStream = (InputStream)ExchangeHelper.convertToMandatoryType((Exchange)exchange, InputStream.class, (Object)graph);
        try {
            KeyGenerator kg = this.getOrCreateKeyGenerator(kemAlg);
            kg.init((AlgorithmParameterSpec)new KEMGenerateSpec(kp.getPublic(), symAlg, this.symmetricKeyLength), new SecureRandom());
            SecretKeyWithEncapsulation secretKey = (SecretKeyWithEncapsulation)kg.generateKey();
            byte[] encapsulation = secretKey.getEncapsulation();
            DataOutputStream dataOut = new DataOutputStream(outputStream);
            dataOut.writeInt(encapsulation.length);
            outputStream.write(encapsulation);
            outputStream.flush();
            Cipher cipher = Cipher.getInstance(symAlg);
            cipher.init(1, (Key)secretKey);
            byte[] buffer = new byte[this.bufferSize];
            CipherOutputStream cipherStream = null;
            try {
                int read;
                cipherStream = new CipherOutputStream(outputStream, cipher);
                while ((read = plaintextStream.read(buffer)) > 0) {
                    cipherStream.write(buffer, 0, read);
                    cipherStream.flush();
                }
            }
            finally {
                IOHelper.close((Closeable)cipherStream, (String)"cipher", (Logger)LOG);
                IOHelper.close((Closeable)plaintextStream, (String)"plaintext", (Logger)LOG);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to encrypt data using PQC KEM", e);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream encryptedStream) throws Exception {
        Object object;
        if (encryptedStream == null) {
            return null;
        }
        KeyPair kp = this.getKeyPair(exchange);
        if (kp == null || kp.getPrivate() == null) {
            throw new IllegalStateException("A valid KeyPair with private key is required for decryption. Either configure the PQCDataFormat with a KeyPair or provide one in a header using 'CamelPQCKeyPair'");
        }
        String kemAlg = this.getKemAlgorithm(exchange);
        String symAlg = this.getSymmetricAlgorithm(exchange);
        CipherInputStream cipherStream = null;
        OutputStreamBuilder osb = null;
        try {
            DataInputStream dataIn = new DataInputStream(encryptedStream);
            int encapsulationLength = dataIn.readInt();
            byte[] encapsulation = new byte[encapsulationLength];
            int read = encryptedStream.read(encapsulation);
            if (read != encapsulationLength) {
                throw new IOException(String.format("Expected to read %d bytes of encapsulation but got %d bytes", encapsulationLength, read));
            }
            KeyGenerator kg = this.getOrCreateKeyGenerator(kemAlg);
            kg.init((AlgorithmParameterSpec)new KEMExtractSpec(kp.getPrivate(), encapsulation, symAlg, this.symmetricKeyLength), new SecureRandom());
            SecretKeyWithEncapsulation secretKey = (SecretKeyWithEncapsulation)kg.generateKey();
            Cipher cipher = Cipher.getInstance(symAlg);
            cipher.init(2, (Key)secretKey);
            cipherStream = new CipherInputStream(encryptedStream, cipher);
            osb = OutputStreamBuilder.withExchange((Exchange)exchange);
            byte[] buffer = new byte[this.bufferSize];
            while ((read = cipherStream.read(buffer)) >= 0) {
                osb.write(buffer, 0, read);
            }
            object = osb.build();
        }
        catch (Exception e) {
            try {
                throw new IOException("Failed to decrypt data using PQC KEM", e);
            }
            catch (Throwable throwable) {
                IOHelper.close(cipherStream, (String)"cipher", (Logger)LOG);
                IOHelper.close(osb, (String)"plaintext", (Logger)LOG);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)cipherStream, (String)"cipher", (Logger)LOG);
        IOHelper.close((Closeable)osb, (String)"plaintext", (Logger)LOG);
        return object;
    }

    protected void doStart() throws Exception {
        if (this.keyEncapsulationAlgorithm != null && this.keyGenerator == null) {
            PQCKeyEncapsulationAlgorithms kemEnum = PQCKeyEncapsulationAlgorithms.valueOf(this.keyEncapsulationAlgorithm);
            String algorithm = kemEnum.getAlgorithm();
            String bcProvider = kemEnum.getBcProvider();
            this.keyGenerator = this.provider != null ? KeyGenerator.getInstance(algorithm, this.provider) : (bcProvider != null ? KeyGenerator.getInstance(algorithm, bcProvider) : KeyGenerator.getInstance(algorithm));
        }
    }

    protected void doStop() throws Exception {
    }

    private KeyPair getKeyPair(Exchange exchange) {
        KeyPair kp = (KeyPair)exchange.getIn().getHeader(KEY_PAIR, KeyPair.class);
        if (kp != null) {
            return kp;
        }
        if (this.keyPair != null) {
            return this.keyPair;
        }
        return (KeyPair)exchange.getContext().getRegistry().lookupByNameAndType("pqcKeyPair", KeyPair.class);
    }

    private String getKemAlgorithm(Exchange exchange) {
        String alg = (String)exchange.getIn().getHeader(KEM_ALGORITHM, String.class);
        return alg != null ? alg : this.keyEncapsulationAlgorithm;
    }

    private String getSymmetricAlgorithm(Exchange exchange) {
        String alg = (String)exchange.getIn().getHeader(SYMMETRIC_ALGORITHM, String.class);
        if (alg != null) {
            return alg;
        }
        try {
            PQCSymmetricAlgorithms symEnum = PQCSymmetricAlgorithms.valueOf(this.symmetricKeyAlgorithm);
            return symEnum.getAlgorithm();
        }
        catch (IllegalArgumentException e) {
            return this.symmetricKeyAlgorithm;
        }
    }

    private KeyGenerator getOrCreateKeyGenerator(String kemAlgorithm) throws Exception {
        if (this.keyGenerator != null) {
            return this.keyGenerator;
        }
        PQCKeyEncapsulationAlgorithms kemEnum = PQCKeyEncapsulationAlgorithms.valueOf(kemAlgorithm);
        String algorithm = kemEnum.getAlgorithm();
        String bcProvider = kemEnum.getBcProvider();
        if (this.provider != null) {
            return KeyGenerator.getInstance(algorithm, this.provider);
        }
        if (bcProvider != null) {
            return KeyGenerator.getInstance(algorithm, bcProvider);
        }
        return KeyGenerator.getInstance(algorithm);
    }

    public String getKeyEncapsulationAlgorithm() {
        return this.keyEncapsulationAlgorithm;
    }

    public void setKeyEncapsulationAlgorithm(String keyEncapsulationAlgorithm) {
        this.keyEncapsulationAlgorithm = keyEncapsulationAlgorithm;
    }

    public String getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public void setSymmetricKeyAlgorithm(String symmetricKeyAlgorithm) {
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
    }

    public int getSymmetricKeyLength() {
        return this.symmetricKeyLength;
    }

    public void setSymmetricKeyLength(int symmetricKeyLength) {
        this.symmetricKeyLength = symmetricKeyLength;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }
}

