/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.camel.component.pqc.PQCSignatureAlgorithms;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.XMSSParameterSpec;

public class PQCDefaultXMSSMaterial {
    public static final KeyPair keyPair;
    public static final Signature signer;

    protected static KeyPairGenerator prepareKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(PQCSignatureAlgorithms.XMSS.getAlgorithm(), PQCSignatureAlgorithms.XMSS.getBcProvider());
        kpGen.initialize((AlgorithmParameterSpec)new XMSSParameterSpec(10, "SHA256"), new SecureRandom());
        return kpGen;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider(BouncyCastlePQCProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastlePQCProvider());
        }
        try {
            KeyPairGenerator generator = PQCDefaultXMSSMaterial.prepareKeyPair();
            keyPair = generator.generateKeyPair();
            signer = Signature.getInstance(PQCSignatureAlgorithms.XMSS.getAlgorithm(), PQCSignatureAlgorithms.XMSS.getBcProvider());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

