/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.pqc.PQCConfiguration;
import org.apache.camel.component.pqc.PQCEndpoint;
import org.apache.camel.component.pqc.PQCKeyEncapsulationAlgorithms;
import org.apache.camel.component.pqc.PQCOperations;
import org.apache.camel.component.pqc.PQCSignatureAlgorithms;
import org.apache.camel.component.pqc.PQCSymmetricAlgorithms;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import org.bouncycastle.jcajce.spec.KEMExtractSpec;
import org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PQCProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PQCProducer.class);
    private Signature signer;
    private KeyGenerator keyGenerator;
    private KeyPair keyPair;

    public PQCProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case sign: {
                this.signature(exchange);
                break;
            }
            case verify: {
                this.verification(exchange);
                break;
            }
            case generateSecretKeyEncapsulation: {
                this.generateEncapsulation(exchange);
                break;
            }
            case extractSecretKeyEncapsulation: {
                this.extractEncapsulation(exchange);
                break;
            }
            case extractSecretKeyFromEncapsulation: {
                this.extractSecretKeyFromEncapsulation(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private PQCOperations determineOperation(Exchange exchange) {
        PQCOperations operation = (PQCOperations)((Object)exchange.getIn().getHeader("CamelPQCOperation", PQCOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected PQCConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public PQCEndpoint getEndpoint() {
        return (PQCEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getConfiguration().getOperation().equals((Object)PQCOperations.sign) || this.getConfiguration().getOperation().equals((Object)PQCOperations.verify)) {
            this.signer = this.getEndpoint().getConfiguration().getSigner();
            if (ObjectHelper.isEmpty((Object)this.signer)) {
                PQCSignatureAlgorithms sigAlg = PQCSignatureAlgorithms.valueOf(this.getConfiguration().getSignatureAlgorithm());
                this.signer = Signature.getInstance(sigAlg.getAlgorithm(), sigAlg.getBcProvider());
            }
        }
        if (this.getConfiguration().getOperation().equals((Object)PQCOperations.generateSecretKeyEncapsulation) || this.getConfiguration().getOperation().equals((Object)PQCOperations.extractSecretKeyEncapsulation)) {
            this.keyGenerator = this.getEndpoint().getConfiguration().getKeyGenerator();
            if (ObjectHelper.isEmpty((Object)this.keyGenerator)) {
                PQCKeyEncapsulationAlgorithms kemAlg = PQCKeyEncapsulationAlgorithms.valueOf(this.getConfiguration().getKeyEncapsulationAlgorithm());
                this.keyGenerator = KeyGenerator.getInstance(kemAlg.getAlgorithm(), kemAlg.getBcProvider());
            }
        }
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getKeyStore()) && ObjectHelper.isNotEmpty((String)this.getConfiguration().getKeyPairAlias()) && ObjectHelper.isNotEmpty((String)this.getConfiguration().getKeyStorePassword())) {
            KeyStore keyStore = this.getConfiguration().getKeyStore();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(this.getConfiguration().getKeyPairAlias(), this.getConfiguration().getKeyStorePassword().toCharArray());
            Certificate cert = keyStore.getCertificate(this.getConfiguration().getKeyPairAlias());
            PublicKey publicKey = cert.getPublicKey();
            this.keyPair = new KeyPair(publicKey, privateKey);
        } else {
            this.keyPair = this.getConfiguration().getKeyPair();
        }
    }

    private void signature(Exchange exchange) throws InvalidPayloadException, InvalidKeyException, SignatureException {
        String payload = (String)exchange.getMessage().getMandatoryBody(String.class);
        this.signer.initSign(this.keyPair.getPrivate());
        this.signer.update(payload.getBytes());
        byte[] signature = this.signer.sign();
        exchange.getMessage().setHeader("CamelPQCSignature", (Object)signature);
    }

    private void verification(Exchange exchange) throws InvalidPayloadException, InvalidKeyException, SignatureException {
        String payload = (String)exchange.getMessage().getMandatoryBody(String.class);
        this.signer.initVerify(this.keyPair.getPublic());
        this.signer.update(payload.getBytes());
        if (this.signer.verify((byte[])exchange.getMessage().getHeader("CamelPQCSignature", byte[].class))) {
            exchange.getMessage().setHeader("CamelPQCVerification", (Object)true);
        } else {
            exchange.getMessage().setHeader("CamelPQCVerification", (Object)false);
        }
    }

    private void generateEncapsulation(Exchange exchange) throws InvalidAlgorithmParameterException {
        this.keyGenerator.init((AlgorithmParameterSpec)new KEMGenerateSpec(this.keyPair.getPublic(), this.getEndpoint().getConfiguration().getSymmetricKeyAlgorithm(), this.getEndpoint().getConfiguration().getSymmetricKeyLength()), new SecureRandom());
        SecretKeyWithEncapsulation secEnc1 = (SecretKeyWithEncapsulation)this.keyGenerator.generateKey();
        exchange.getMessage().setBody((Object)secEnc1, SecretKeyWithEncapsulation.class);
    }

    private void extractEncapsulation(Exchange exchange) throws InvalidAlgorithmParameterException, InvalidPayloadException {
        SecretKeyWithEncapsulation payload = (SecretKeyWithEncapsulation)exchange.getMessage().getMandatoryBody(SecretKeyWithEncapsulation.class);
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getSymmetricKeyAlgorithm())) {
            throw new IllegalArgumentException("Symmetric Algorithm needs to be specified");
        }
        this.keyGenerator.init((AlgorithmParameterSpec)new KEMExtractSpec(this.keyPair.getPrivate(), payload.getEncapsulation(), PQCSymmetricAlgorithms.valueOf(this.getConfiguration().getSymmetricKeyAlgorithm()).getAlgorithm(), this.getEndpoint().getConfiguration().getSymmetricKeyLength()), new SecureRandom());
        SecretKeyWithEncapsulation secEnc2 = (SecretKeyWithEncapsulation)this.keyGenerator.generateKey();
        exchange.getMessage().setBody((Object)secEnc2, SecretKeyWithEncapsulation.class);
    }

    private void extractSecretKeyFromEncapsulation(Exchange exchange) throws InvalidPayloadException {
        SecretKeyWithEncapsulation payload = (SecretKeyWithEncapsulation)exchange.getMessage().getMandatoryBody(SecretKeyWithEncapsulation.class);
        if (ObjectHelper.isEmpty((String)this.getConfiguration().getSymmetricKeyAlgorithm())) {
            throw new IllegalArgumentException("Symmetric Algorithm needs to be specified");
        }
        SecretKeySpec restoredKey = new SecretKeySpec(payload.getEncoded(), this.getConfiguration().getSymmetricKeyAlgorithm());
        if (!this.getConfiguration().isStoreExtractedSecretKeyAsHeader()) {
            exchange.getMessage().setBody((Object)restoredKey, SecretKey.class);
        } else {
            exchange.getMessage().setHeader("CamelPQCSecretKey", (Object)restoredKey);
        }
    }
}

