/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc.crypto.kem;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import org.apache.camel.component.pqc.PQCKeyEncapsulationAlgorithms;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.BIKEParameterSpec;

public class PQCDefaultBIKEMaterial {
    public static final KeyPair keyPair;
    public static final KeyGenerator keyGenerator;
    public static final KeyPairGenerator generator;

    protected static KeyPairGenerator prepareKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(PQCKeyEncapsulationAlgorithms.BIKE.getAlgorithm(), PQCKeyEncapsulationAlgorithms.BIKE.getBcProvider());
        kpg.initialize((AlgorithmParameterSpec)BIKEParameterSpec.bike192, new SecureRandom());
        return kpg;
    }

    protected static KeyGenerator prepareKeyGenerator() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kg = KeyGenerator.getInstance(PQCKeyEncapsulationAlgorithms.BIKE.getAlgorithm(), PQCKeyEncapsulationAlgorithms.BIKE.getBcProvider());
        return kg;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProvider(BouncyCastlePQCProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastlePQCProvider());
        }
        try {
            generator = PQCDefaultBIKEMaterial.prepareKeyPair();
            keyPair = generator.generateKeyPair();
            keyGenerator = PQCDefaultBIKEMaterial.prepareKeyGenerator();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

