/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Signature;
import javax.crypto.KeyGenerator;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.pqc.PQCOperations;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class PQCConfiguration
implements Cloneable {
    @UriPath(description="Logical name")
    @Metadata(required=true)
    private String label;
    @UriParam
    @Metadata(label="advanced", autowired=true)
    private KeyPair keyPair;
    @UriParam
    @Metadata(required=true)
    private PQCOperations operation;
    @UriParam
    @Metadata(label="advanced", autowired=true)
    private Signature signer;
    @UriParam(enums="MLDSA,SLHDSA,LMS,XMSS,FALCON,PICNIC,RAINBOW")
    @Metadata(label="advanced")
    private String signatureAlgorithm;
    @UriParam
    @Metadata(label="advanced", autowired=true)
    private KeyGenerator keyGenerator;
    @UriParam(enums="MLKEM,BIKE,HQC,CMCE,SABER,FRODO,NTRU,NTRULPRime")
    @Metadata(label="advanced")
    private String keyEncapsulationAlgorithm;
    @UriParam(enums="AES,ARIA,RC2,RC5,CAMELLIA,CAST5,CAST6,CHACHA7539,DSTU7624,GOST28147,GOST3412_2015,GRAIN128,HC128,HC256,SALSA20,SEED,SM4,DESEDE")
    @Metadata(label="advanced")
    private String symmetricKeyAlgorithm;
    @UriParam
    @Metadata(label="advanced", defaultValue="128")
    private int symmetricKeyLength = 128;
    @UriParam
    @Metadata(label="advanced", defaultValue="false")
    private boolean storeExtractedSecretKeyAsHeader = false;
    @UriParam
    @Metadata(label="advanced", autowired=true)
    private KeyStore keyStore;
    @UriParam
    @Metadata(label="advanced")
    private String keyPairAlias;
    @UriParam
    @Metadata(label="advanced", secret=true)
    private String keyStorePassword;

    public PQCOperations getOperation() {
        return this.operation;
    }

    public void setOperation(PQCOperations operation) {
        this.operation = operation;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public Signature getSigner() {
        return this.signer;
    }

    public void setSigner(Signature signer) {
        this.signer = signer;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public String getKeyEncapsulationAlgorithm() {
        return this.keyEncapsulationAlgorithm;
    }

    public void setKeyEncapsulationAlgorithm(String keyEncapsulationAlgorithm) {
        this.keyEncapsulationAlgorithm = keyEncapsulationAlgorithm;
    }

    public String getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public void setSymmetricKeyAlgorithm(String symmetricKeyAlgorithm) {
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
    }

    public int getSymmetricKeyLength() {
        return this.symmetricKeyLength;
    }

    public void setSymmetricKeyLength(int symmetricKeyLength) {
        this.symmetricKeyLength = symmetricKeyLength;
    }

    public boolean isStoreExtractedSecretKeyAsHeader() {
        return this.storeExtractedSecretKeyAsHeader;
    }

    public void setStoreExtractedSecretKeyAsHeader(boolean storeExtractedSecretKeyAsHeader) {
        this.storeExtractedSecretKeyAsHeader = storeExtractedSecretKeyAsHeader;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyPairAlias() {
        return this.keyPairAlias;
    }

    public void setKeyPairAlias(String keyPairAlias) {
        this.keyPairAlias = keyPairAlias;
    }

    public PQCConfiguration copy() {
        try {
            return (PQCConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

