/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pqc;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.pqc.PQCConfiguration;
import org.apache.camel.component.pqc.PQCEndpoint;
import org.apache.camel.component.pqc.crypto.PQCDefaultFalconMaterial;
import org.apache.camel.component.pqc.crypto.PQCDefaultLMSMaterial;
import org.apache.camel.component.pqc.crypto.PQCDefaultMLDSAMaterial;
import org.apache.camel.component.pqc.crypto.PQCDefaultPicnicMaterial;
import org.apache.camel.component.pqc.crypto.PQCDefaultSLHDSAMaterial;
import org.apache.camel.component.pqc.crypto.PQCDefaultXMSSMaterial;
import org.apache.camel.component.pqc.crypto.kem.PQCDefaultBIKEMaterial;
import org.apache.camel.component.pqc.crypto.kem.PQCDefaultCMCEMaterial;
import org.apache.camel.component.pqc.crypto.kem.PQCDefaultFRODOMaterial;
import org.apache.camel.component.pqc.crypto.kem.PQCDefaultHQCMaterial;
import org.apache.camel.component.pqc.crypto.kem.PQCDefaultMLKEMMaterial;
import org.apache.camel.component.pqc.crypto.kem.PQCDefaultNTRULPRimeMaterial;
import org.apache.camel.component.pqc.crypto.kem.PQCDefaultNTRUMaterial;
import org.apache.camel.component.pqc.crypto.kem.PQCDefaultSABERMaterial;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="pqc")
public class PQCComponent
extends HealthCheckComponent {
    @Metadata
    private PQCConfiguration configuration = new PQCConfiguration();

    public PQCComponent() {
        this(null);
    }

    public PQCComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        PQCConfiguration configuration = this.configuration != null ? this.configuration.copy() : new PQCConfiguration();
        PQCEndpoint endpoint = new PQCEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ObjectHelper.isEmpty((Object)configuration.getSigner()) && ObjectHelper.isEmpty((Object)configuration.getKeyPair()) && ObjectHelper.isEmpty((Object)configuration.getKeyStore()) && ObjectHelper.isEmpty((String)configuration.getKeyPairAlias()) && ObjectHelper.isNotEmpty((String)configuration.getSignatureAlgorithm())) {
            switch (configuration.getSignatureAlgorithm()) {
                case "MLDSA": {
                    configuration.setSigner(PQCDefaultMLDSAMaterial.signer);
                    configuration.setKeyPair(PQCDefaultMLDSAMaterial.keyPair);
                    break;
                }
                case "SLHDSA": {
                    configuration.setSigner(PQCDefaultSLHDSAMaterial.signer);
                    configuration.setKeyPair(PQCDefaultSLHDSAMaterial.keyPair);
                    break;
                }
                case "LMS": {
                    configuration.setSigner(PQCDefaultLMSMaterial.signer);
                    configuration.setKeyPair(PQCDefaultLMSMaterial.keyPair);
                    break;
                }
                case "XMSS": {
                    configuration.setSigner(PQCDefaultXMSSMaterial.signer);
                    configuration.setKeyPair(PQCDefaultXMSSMaterial.keyPair);
                    break;
                }
                case "FALCON": {
                    configuration.setSigner(PQCDefaultFalconMaterial.signer);
                    configuration.setKeyPair(PQCDefaultFalconMaterial.keyPair);
                    break;
                }
                case "PICNIC": {
                    configuration.setSigner(PQCDefaultPicnicMaterial.signer);
                    configuration.setKeyPair(PQCDefaultPicnicMaterial.keyPair);
                    break;
                }
            }
        }
        if (ObjectHelper.isEmpty((Object)configuration.getKeyGenerator()) && ObjectHelper.isEmpty((Object)configuration.getKeyPair()) && ObjectHelper.isEmpty((Object)configuration.getKeyStore()) && ObjectHelper.isEmpty((String)configuration.getKeyPairAlias()) && ObjectHelper.isNotEmpty((String)configuration.getKeyEncapsulationAlgorithm())) {
            switch (configuration.getKeyEncapsulationAlgorithm()) {
                case "MLKEM": {
                    configuration.setKeyGenerator(PQCDefaultMLKEMMaterial.keyGenerator);
                    configuration.setKeyPair(PQCDefaultMLKEMMaterial.keyPair);
                    break;
                }
                case "BIKE": {
                    configuration.setKeyGenerator(PQCDefaultBIKEMaterial.keyGenerator);
                    configuration.setKeyPair(PQCDefaultBIKEMaterial.keyPair);
                    break;
                }
                case "HQC": {
                    configuration.setKeyGenerator(PQCDefaultHQCMaterial.keyGenerator);
                    configuration.setKeyPair(PQCDefaultHQCMaterial.keyPair);
                    break;
                }
                case "CMCE": {
                    configuration.setKeyGenerator(PQCDefaultCMCEMaterial.keyGenerator);
                    configuration.setKeyPair(PQCDefaultCMCEMaterial.keyPair);
                    break;
                }
                case "SABER": {
                    configuration.setKeyGenerator(PQCDefaultSABERMaterial.keyGenerator);
                    configuration.setKeyPair(PQCDefaultSABERMaterial.keyPair);
                    break;
                }
                case "FRODO": {
                    configuration.setKeyGenerator(PQCDefaultFRODOMaterial.keyGenerator);
                    configuration.setKeyPair(PQCDefaultFRODOMaterial.keyPair);
                    break;
                }
                case "NTRU": {
                    configuration.setKeyGenerator(PQCDefaultNTRUMaterial.keyGenerator);
                    configuration.setKeyPair(PQCDefaultNTRUMaterial.keyPair);
                    break;
                }
                case "NTRULPRime": {
                    configuration.setKeyGenerator(PQCDefaultNTRULPRimeMaterial.keyGenerator);
                    configuration.setKeyPair(PQCDefaultNTRULPRimeMaterial.keyPair);
                    break;
                }
            }
        }
        return endpoint;
    }

    public PQCConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PQCConfiguration configuration) {
        this.configuration = configuration;
    }
}

