/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main;

import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.StartupListener;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainHttpServerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MainHttpServerUtil.class);

    protected static void setupStartupSummary(final CamelContext camelContext, final Set<HttpEndpointModel> endpoints, final int serverPort, final String header) throws Exception {
        camelContext.addStartupListener(new StartupListener(){
            private volatile Set<HttpEndpointModel> last;

            private void logSummary() {
                if (endpoints.isEmpty()) {
                    return;
                }
                if (this.last == null || this.last.size() != endpoints.size() || !this.last.containsAll(endpoints)) {
                    LOG.info(header);
                    int longestEndpoint = 0;
                    int longestVerbs = 0;
                    for (HttpEndpointModel u : endpoints) {
                        String endpoint = this.getEndpoint(u);
                        if (endpoint.length() > longestEndpoint) {
                            longestEndpoint = endpoint.length();
                        }
                        if (u.getVerbs() == null || u.getVerbs().length() <= longestVerbs) continue;
                        longestVerbs = u.getVerbs().length();
                    }
                    longestVerbs += 2;
                    longestVerbs = Math.max(8, longestVerbs);
                    String formatTemplate = "%-" + (longestEndpoint += 3) + "s %-" + longestVerbs + "s %s";
                    for (HttpEndpointModel u : endpoints) {
                        String endpoint = this.getEndpoint(u);
                        Object formattedVerbs = "";
                        if (u.getVerbs() != null) {
                            formattedVerbs = "(" + u.getVerbs() + ")";
                        }
                        String formattedMediaTypes = "";
                        if (u.getConsumes() != null || u.getProduces() != null) {
                            formattedMediaTypes = String.format("(%s%s%s)", u.getConsumes() != null ? "accept:" + u.getConsumes() : "", u.getProduces() != null && u.getConsumes() != null ? " " : "", u.getProduces() != null ? "produce:" + u.getProduces() : "");
                        }
                        LOG.info("    {}", (Object)String.format(formatTemplate, endpoint, formattedVerbs, formattedMediaTypes));
                    }
                }
                this.last = new HashSet<HttpEndpointModel>(endpoints);
            }

            private String getEndpoint(HttpEndpointModel httpEndpointModel) {
                return "http://0.0.0.0:" + serverPort + httpEndpointModel.getUri();
            }

            public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) {
                if (alreadyStarted) {
                    this.logSummary();
                }
                camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

                    public boolean isEnabled(CamelEvent event) {
                        return event instanceof CamelEvent.CamelContextStartedEvent || event instanceof CamelEvent.RouteReloadedEvent;
                    }

                    public void notify(CamelEvent event) {
                        CamelEvent.RouteReloadedEvent re;
                        if (event instanceof CamelEvent.RouteReloadedEvent && (re = (CamelEvent.RouteReloadedEvent)event).getIndex() < re.getTotal()) {
                            return;
                        }
                        this.logSummary();
                    }
                });
            }
        });
    }
}

