/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Service;
import org.apache.camel.component.platform.http.main.MainHttpServer;
import org.apache.camel.component.platform.http.main.ManagementHttpServer;
import org.apache.camel.component.platform.http.main.authentication.BasicAuthenticationConfigurer;
import org.apache.camel.component.platform.http.main.authentication.JWTAuthenticationConfigurer;
import org.apache.camel.main.HttpManagementServerConfigurationProperties;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.main.MainHttpServerFactory;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.TempDirHelper;
import org.apache.camel.util.ObjectHelper;

@JdkService(value="platform-http-server")
public class DefaultMainHttpServerFactory
implements CamelContextAware,
MainHttpServerFactory {
    private static final String DEFAULT_UPLOAD_DIR = "${java.io.tmpdir}/camel/camel-tmp-#uuid#/";
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Service newHttpServer(CamelContext camelContext, HttpServerConfigurationProperties configuration) {
        MainHttpServer server = new MainHttpServer();
        server.setCamelContext(camelContext);
        server.setHost(configuration.getHost());
        server.setPort(configuration.getPort());
        server.setPath(configuration.getPath());
        if (configuration.getMaxBodySize() != null) {
            server.setMaxBodySize(configuration.getMaxBodySize());
        }
        server.setUseGlobalSslContextParameters(configuration.isUseGlobalSslContextParameters());
        server.setFileUploadEnabled(configuration.isFileUploadEnabled());
        if (configuration.isFileUploadEnabled()) {
            String dir = configuration.getFileUploadDirectory();
            if (dir == null) {
                dir = DEFAULT_UPLOAD_DIR;
            }
            dir = TempDirHelper.resolveTempDir((CamelContext)camelContext, null, (String)dir);
            server.setFileUploadDirectory(dir);
        }
        server.setInfoEnabled(configuration.isInfoEnabled());
        server.setStaticEnabled(configuration.isStaticEnabled());
        server.setStaticContextPath(configuration.getStaticContextPath());
        server.setStaticSourceDir(configuration.getStaticSourceDir());
        server.setDevConsoleEnabled(configuration.isDevConsoleEnabled());
        server.setHealthCheckEnabled(configuration.isHealthCheckEnabled());
        server.setHealthPath(configuration.getHealthPath());
        server.setJolokiaEnabled(configuration.isJolokiaEnabled());
        server.setJolokiaPath(configuration.getJolokiaPath());
        server.setMetricsEnabled(configuration.isMetricsEnabled());
        server.setUploadEnabled(configuration.isUploadEnabled());
        server.setUploadSourceDir(configuration.getUploadSourceDir());
        server.setDownloadEnabled(configuration.isDownloadEnabled());
        server.setSendEnabled(configuration.isSendEnabled());
        if (configuration.isAuthenticationEnabled()) {
            this.configureAuthentication(server, configuration);
        }
        return server;
    }

    public Service newHttpManagementServer(CamelContext camelContext, HttpManagementServerConfigurationProperties configuration) {
        ManagementHttpServer server = new ManagementHttpServer();
        server.setCamelContext(camelContext);
        server.setHost(configuration.getHost());
        server.setPort(configuration.getPort());
        server.setPath(configuration.getPath());
        if (configuration.getMaxBodySize() != null) {
            server.setMaxBodySize(configuration.getMaxBodySize());
        }
        server.setUseGlobalSslContextParameters(configuration.isUseGlobalSslContextParameters());
        server.setInfoEnabled(configuration.isInfoEnabled());
        server.setDevConsoleEnabled(configuration.isDevConsoleEnabled());
        server.setHealthCheckEnabled(configuration.isHealthCheckEnabled());
        server.setHealthPath(configuration.getHealthPath());
        server.setJolokiaEnabled(configuration.isJolokiaEnabled());
        server.setJolokiaPath(configuration.getJolokiaPath());
        server.setMetricsEnabled(configuration.isMetricsEnabled());
        if (configuration.isAuthenticationEnabled()) {
            this.configureAuthentication(server, configuration);
        }
        return server;
    }

    private void configureAuthentication(MainHttpServer server, HttpServerConfigurationProperties configuration) {
        if (configuration.getBasicPropertiesFile() != null) {
            BasicAuthenticationConfigurer auth = new BasicAuthenticationConfigurer();
            auth.configureAuthentication(server.getConfiguration().getAuthenticationConfig(), configuration);
        } else if (configuration.getJwtKeystoreType() != null) {
            ObjectHelper.notNull((Object)configuration.getJwtKeystorePath(), (String)"jwtKeyStorePath");
            ObjectHelper.notNull((Object)configuration.getJwtKeystorePassword(), (String)"jwtKeyStorePassword");
            JWTAuthenticationConfigurer auth = new JWTAuthenticationConfigurer();
            auth.configureAuthentication(server.getConfiguration().getAuthenticationConfig(), configuration);
        }
    }

    private void configureAuthentication(ManagementHttpServer server, HttpManagementServerConfigurationProperties configuration) {
        if (configuration.getBasicPropertiesFile() != null) {
            BasicAuthenticationConfigurer auth = new BasicAuthenticationConfigurer();
            auth.configureAuthentication(server.getConfiguration().getAuthenticationConfig(), configuration);
        } else if (configuration.getJwtKeystoreType() != null) {
            ObjectHelper.notNull((Object)configuration.getJwtKeystorePath(), (String)"jwtKeyStorePath");
            ObjectHelper.notNull((Object)configuration.getJwtKeystorePassword(), (String)"jwtKeyStorePassword");
            JWTAuthenticationConfigurer auth = new JWTAuthenticationConfigurer();
            auth.configureAuthentication(server.getConfiguration().getAuthenticationConfig(), configuration);
        }
    }
}

