/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pinecone;

import io.pinecone.clients.Pinecone;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pinecone.PineconeVectorDb;
import org.apache.camel.component.pinecone.PineconeVectorDbConfiguration;
import org.apache.camel.component.pinecone.PineconeVectorDbProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.6.0", scheme="pinecone", title="Pinecone", syntax="pinecone:collection", producerOnly=true, category={Category.DATABASE, Category.AI}, headersClass=PineconeVectorDb.Headers.class)
public class PineconeVectorDbEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The collection Name")
    private final String collection;
    @UriParam
    private PineconeVectorDbConfiguration configuration;
    private Pinecone client;

    public PineconeVectorDbEndpoint(String endpointUri, Component component, String collection, PineconeVectorDbConfiguration configuration) {
        super(endpointUri, component);
        this.collection = collection;
        this.configuration = configuration;
    }

    public PineconeVectorDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getCollection() {
        return this.collection;
    }

    public synchronized Pinecone getClient() {
        if (this.client == null) {
            this.client = this.configuration.getClient();
            if (this.client == null) {
                this.client = this.createClient();
            }
        }
        return this.client;
    }

    public Producer createProducer() throws Exception {
        return new PineconeVectorDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
    }

    private Pinecone createClient() {
        Pinecone pinecone = new Pinecone.Builder(this.configuration.getToken()).build();
        return pinecone;
    }
}

