/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pinecone;

import com.google.protobuf.Struct;
import io.pinecone.clients.Index;
import io.pinecone.clients.Pinecone;
import io.pinecone.proto.DeleteResponse;
import io.pinecone.proto.FetchResponse;
import io.pinecone.proto.UpdateResponse;
import io.pinecone.proto.UpsertResponse;
import io.pinecone.unsigned_indices_model.QueryResponseWithUnsignedIndices;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.pinecone.PineconeVectorDbAction;
import org.apache.camel.component.pinecone.PineconeVectorDbEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.openapitools.db_control.client.model.CollectionModel;
import org.openapitools.db_control.client.model.DeletionProtection;
import org.openapitools.db_control.client.model.IndexModel;

public class PineconeVectorDbProducer
extends DefaultProducer {
    private Pinecone client;
    private ExecutorService executor;

    public PineconeVectorDbProducer(PineconeVectorDbEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public PineconeVectorDbEndpoint getEndpoint() {
        return (PineconeVectorDbEndpoint)super.getEndpoint();
    }

    public void doStart() throws Exception {
        super.doStart();
        this.client = this.getEndpoint().getClient();
    }

    public void process(Exchange exchange) {
        Message in = exchange.getMessage();
        PineconeVectorDbAction action = (PineconeVectorDbAction)((Object)in.getHeader("CamelPineconeAction", PineconeVectorDbAction.class));
        try {
            if (action == null) {
                throw new NoSuchHeaderException("The action is a required header", exchange, "CamelPineconeAction");
            }
            switch (action) {
                case CREATE_COLLECTION: {
                    this.createCollection(exchange);
                    break;
                }
                case CREATE_SERVERLESS_INDEX: {
                    this.createServerlessIndex(exchange);
                    break;
                }
                case CREATE_POD_INDEX: {
                    this.createPodIndex(exchange);
                    break;
                }
                case UPSERT: {
                    this.upsert(exchange);
                    break;
                }
                case UPDATE: {
                    this.update(exchange);
                    break;
                }
                case DELETE_INDEX: {
                    this.deleteIndex(exchange);
                    break;
                }
                case DELETE_COLLECTION: {
                    this.deleteCollection(exchange);
                    break;
                }
                case FETCH: {
                    this.fetch(exchange);
                    break;
                }
                case QUERY: {
                    this.query(exchange);
                    break;
                }
                case QUERY_BY_ID: {
                    this.queryById(exchange);
                    break;
                }
                case DELETE_BY_ID: {
                    this.deleteByIds(exchange);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported action: " + action.name());
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
    }

    private void createCollection(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        String collectionName = (String)in.getHeader("CamelPineconeCollectionName", String.class);
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        CollectionModel result = this.client.createCollection(collectionName, indexName);
        this.populateCollectionResponse(result, exchange);
    }

    private void createServerlessIndex(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        String collectionSimilarityMetricName = this.getEndpoint().getConfiguration().getCollectionSimilarityMetric();
        String collectionCloudName = this.getEndpoint().getConfiguration().getCloud();
        String collectionCloudRegionName = this.getEndpoint().getConfiguration().getCloudRegion();
        int collectionDimension = 1536;
        if (this.getEndpoint().getConfiguration().getCollectionDimension() != null) {
            collectionDimension = this.getEndpoint().getConfiguration().getCollectionDimension();
        }
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        if (in.getHeader("CamelPineconeCollectionSimilarityMetric", String.class) != null) {
            collectionSimilarityMetricName = (String)in.getHeader("CamelPineconeCollectionSimilarityMetric", String.class);
        }
        if (in.getHeader("CamelPineconeCollectionDimension", Integer.class) != null) {
            collectionDimension = (Integer)in.getHeader("CamelPineconeCollectionDimension", Integer.class);
        }
        if (in.getHeader("CamelPineconeCollectionCloud", String.class) != null) {
            collectionCloudName = (String)in.getHeader("CamelPineconeCollectionCloud", String.class);
        }
        if (in.getHeader("CamelPineconeCollectionCloudRegion", String.class) != null) {
            collectionCloudRegionName = (String)in.getHeader("CamelPineconeCollectionCloudRegion", String.class);
        }
        IndexModel result = this.client.createServerlessIndex(indexName, collectionSimilarityMetricName, collectionDimension, collectionCloudName, collectionCloudRegionName, DeletionProtection.DISABLED);
        this.populateIndexResponse(result, exchange);
    }

    private void createPodIndex(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        String collectionSimilarityMetricName = this.getEndpoint().getConfiguration().getCollectionSimilarityMetric();
        int collectionDimension = 1536;
        if (this.getEndpoint().getConfiguration().getCollectionDimension() != null) {
            collectionDimension = this.getEndpoint().getConfiguration().getCollectionDimension();
        }
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        if (in.getHeader("CamelPineconeCollectionSimilarityMetric", String.class) != null) {
            collectionSimilarityMetricName = (String)in.getHeader("CamelPineconeCollectionSimilarityMetric", String.class);
        }
        if (in.getHeader("CamelPineconeCollectionDimension", Integer.class) != null) {
            collectionDimension = (Integer)in.getHeader("CamelPineconeCollectionDimension", Integer.class);
        }
        String indexPodType = (String)in.getHeader("CamelPineconeIndexPodType", String.class);
        String indexPodEnv = (String)in.getHeader("CamelPineconeIndexPodEnvironment", String.class);
        IndexModel result = this.client.createPodsIndex(indexName, Integer.valueOf(collectionDimension), indexPodEnv, indexPodType, collectionSimilarityMetricName);
        this.populateIndexResponse(result, exchange);
    }

    private void upsert(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        String indexId = (String)in.getHeader("CamelPineconeIndexId", String.class);
        String namespace = (String)in.getHeader("CamelPineconeNamespace", String.class);
        Index index = this.client.getIndexConnection(indexName);
        UpsertResponse result = index.upsert(indexId, elements, null, null, null, namespace);
        this.populateUpsertResponse(result, exchange);
    }

    private void update(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        String indexId = (String)in.getHeader("CamelPineconeIndexId", String.class);
        String namespace = (String)in.getHeader("CamelPineconeNamespace", String.class);
        Index index = this.client.getIndexConnection(indexName);
        UpdateResponse result = index.update(indexId, elements, namespace);
        this.populateUpdateResponse(result, exchange);
    }

    private void deleteIndex(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        this.client.deleteIndex(indexName);
    }

    private void deleteCollection(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String collectionName = (String)in.getHeader("CamelPineconeCollectionName", String.class);
        this.client.deleteCollection(collectionName);
    }

    private void deleteByIds(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        Index index = this.client.getIndexConnection(indexName);
        DeleteResponse result = index.deleteByIds(elements);
        this.populateDeleteResponse(result, exchange);
    }

    private void fetch(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        Index index = this.client.getIndexConnection(indexName);
        FetchResponse result = index.fetch(elements);
        this.populateFetchResponse(result, exchange);
    }

    private void query(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        List elements = (List)in.getMandatoryBody(List.class);
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        int topK = (Integer)in.getHeader("CamelPineconeQueryTopK", Integer.class);
        Index index = this.client.getIndexConnection(indexName);
        String namespace = (String)in.getHeader("CamelPineconeNamespace", String.class);
        Struct filter = (Struct)in.getHeader("CamelPineconeQueryFilter", Struct.class);
        boolean includeValues = in.getHeader("CamelPineconeQueryIncludeValues", Boolean.class) == null ? false : (Boolean)in.getHeader("CamelPineconeQueryIncludeValues", Boolean.class);
        boolean includeMetadata = in.getHeader("CamelPineconeQueryIncludeMetadata", Boolean.class) == null ? false : (Boolean)in.getHeader("CamelPineconeQueryIncludeMetadata", Boolean.class);
        QueryResponseWithUnsignedIndices result = index.queryByVector(topK, elements, namespace, filter, includeValues, includeMetadata);
        this.populateQueryResponse(result, exchange);
    }

    private void queryById(Exchange exchange) throws Exception {
        Message in = exchange.getMessage();
        String indexName = this.getEndpoint().getConfiguration().getIndexName();
        if (in.getHeader("CamelPineconeIndexName", String.class) != null) {
            indexName = (String)in.getHeader("CamelPineconeIndexName", String.class);
        }
        int topK = (Integer)in.getHeader("CamelPineconeQueryTopK", Integer.class);
        Index index = this.client.getIndexConnection(indexName);
        String indexId = (String)in.getHeader("CamelPineconeIndexId", String.class);
        String namespace = (String)in.getHeader("CamelPineconeNamespace", String.class);
        Struct filter = (Struct)in.getHeader("CamelPineconeQueryFilter", Struct.class);
        boolean includeValues = in.getHeader("CamelPineconeQueryIncludeValues", Boolean.class) == null ? false : (Boolean)in.getHeader("CamelPineconeQueryIncludeValues", Boolean.class);
        boolean includeMetadata = in.getHeader("CamelPineconeQueryIncludeMetadata", Boolean.class) == null ? false : (Boolean)in.getHeader("CamelPineconeQueryIncludeMetadata", Boolean.class);
        QueryResponseWithUnsignedIndices result = index.queryByVectorId(topK, indexId, namespace, filter, includeValues, includeMetadata);
        this.populateQueryResponse(result, exchange);
    }

    private CamelContext getCamelContext() {
        return this.getEndpoint().getCamelContext();
    }

    private void populateCollectionResponse(CollectionModel r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateFetchResponse(FetchResponse r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateIndexResponse(IndexModel r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateUpsertResponse(UpsertResponse r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateUpdateResponse(UpdateResponse r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateQueryResponse(QueryResponseWithUnsignedIndices r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }

    private void populateDeleteResponse(DeleteResponse r, Exchange exchange) {
        Message out = exchange.getMessage();
        out.setBody((Object)r);
    }
}

