/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import org.apache.camel.tooling.model.SupportLevel;
import org.apache.camel.tooling.util.CamelVersionHelper;
import org.apache.camel.tooling.util.Version;

public final class SupportLevelHelper {
    private SupportLevelHelper() {
    }

    public static SupportLevel defaultSupportLevel(String firstVersion, String currentVersion) {
        if (firstVersion == null || firstVersion.isEmpty()) {
            throw new IllegalArgumentException("FirstVersion is not specified. This can be done in @UriEndpoint or in pom.xml file.");
        }
        Version v1 = new Version(firstVersion);
        v1 = new Version(v1.getMajor() + "." + v1.getMinor());
        Version v2 = new Version(currentVersion);
        v2 = new Version(v2.getMajor() + "." + v2.getMinor());
        boolean justNew = CamelVersionHelper.isGE((String)v2.toString(), (String)v1.toString());
        boolean prevNew = CamelVersionHelper.isGE((String)CamelVersionHelper.prevMinor((String)v2.toString()), (String)v1.toString());
        if (justNew || prevNew) {
            return SupportLevel.Preview;
        }
        return SupportLevel.Stable;
    }
}

