/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-eips-list", threadSafe=true)
public class PackageModelMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File outDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<String> models;
        if (this.buildDir == null) {
            this.buildDir = new File(this.project.getBuild().getDirectory());
        }
        if (this.outDir == null) {
            this.outDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        File camelMetaDir = new File(this.outDir, "META-INF/services/org/apache/camel/");
        camelMetaDir.mkdirs();
        try (Stream jsonFiles = PackageHelper.findJsonFiles((Path)this.buildDir.toPath().resolve("classes/META-INF/org/apache/camel/model"));){
            models = jsonFiles.filter(p -> !p.getParent().getFileName().toString().endsWith("app")).map(p -> p.getFileName().toString()).map(s -> s.substring(0, s.length() - ".json".length())).sorted().toList();
        }
        if (!models.isEmpty()) {
            StringBuilder sb = new StringBuilder(256);
            sb.append("# ").append("Generated by camel build tools - do NOT edit this file!").append("\n");
            for (String name : models) {
                sb.append(name).append("\n");
            }
            this.updateResource(camelMetaDir.toPath(), "model.properties", sb.toString());
            this.getLog().info((CharSequence)("Generated model.properties containing " + models.size() + " Camel models"));
        }
    }
}

