/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOError;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.dsl.DslHelper;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="generate-component-dsl", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ComponentDslMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter
    protected File sourcesOutputDir;
    @Parameter
    protected File componentsMetadata;
    @Parameter
    protected File outputResourcesDir;
    @Parameter(property="camel.pmp.package-name", defaultValue="org.apache.camel.builder.component")
    protected String componentsDslPackageName;
    @Parameter(property="camel.pmp.factories-package-name", defaultValue="org.apache.camel.builder.component.dsl")
    protected String componentsDslFactoriesPackageName;
    @Parameter(property="camel.pmp.json-directory", defaultValue="${project.basedir}/../../catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/components")
    protected File jsonDir;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.baseDir = project.getBasedir();
        this.componentsDslPackageName = "org.apache.camel.builder.component";
        this.componentsDslFactoriesPackageName = "org.apache.camel.builder.component.dsl";
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"dsl/camel-componentdsl");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No dsl/camel-componentdsl folder found, skipping execution");
            return;
        }
        if (this.jsonDir == null) {
            this.jsonDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/components");
            if (this.jsonDir == null) {
                this.getLog().debug((CharSequence)"No json directory folder found, skipping execution");
                return;
            }
        }
        Path root = camelDir.toPath();
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = root.resolve("src/generated/java").toFile();
        }
        if (this.outputResourcesDir == null) {
            this.outputResourcesDir = root.resolve("src/generated/resources").toFile();
        }
        if (this.componentsMetadata == null) {
            this.componentsMetadata = this.outputResourcesDir.toPath().resolve("metadata.json").toFile();
        }
        ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
        File[] files = this.jsonDir.listFiles();
        if (files != null) {
            for (File file : files) {
                BaseModel model = JsonMapper.generateModel((Path)file.toPath());
                models.add((ComponentModel)model);
            }
        } else {
            throw new IllegalStateException("Error listing directory: " + String.valueOf(this.jsonDir));
        }
        models.sort((o1, o2) -> o1.getScheme().compareToIgnoreCase(o2.getScheme()));
        this.executeComponent(models);
    }

    private void executeComponent(List<ComponentModel> allModels) throws MojoFailureException {
        if (allModels.isEmpty()) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found " + allModels.size() + " components"));
        }
        for (ComponentModel model : allModels) {
            String componentName = this.capitalize(this.toCamelCaseLower(model.getScheme()));
            String packageName = this.componentsDslFactoriesPackageName;
            String className = componentName + "ComponentBuilderFactory";
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("generatorClass", ((Object)((Object)this)).getClass().getName());
            ctx.put("dslPackage", this.componentsDslPackageName);
            ctx.put("packageName", packageName);
            ctx.put("className", className);
            ctx.put("model", model);
            ctx.put("mojo", (Object)this);
            ctx.put("configurationOption", ComponentDslMojo.findConfiguration(model.getComponentOptions()).orElse(null));
            String source = this.velocity("velocity/component-builder.vm", ctx);
            this.writeSourceIfChanged(source, packageName, className);
        }
        String packageName = this.componentsDslPackageName;
        String className = "ComponentsBuilderFactory";
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("generatorClass", ((Object)((Object)this)).getClass().getName());
        ctx.put("dslFactoriesPackage", this.componentsDslFactoriesPackageName);
        ctx.put("packageName", packageName);
        ctx.put("className", className);
        ctx.put("models", allModels);
        ctx.put("mojo", (Object)this);
        String source = this.velocity("velocity/component-builder-factory.vm", ctx);
        this.writeSourceIfChanged(source, packageName, className);
    }

    private boolean writeSourceIfChanged(String code, String packageName, String className) throws MojoFailureException {
        String fileName = packageName.replace('.', '/') + "/" + className + ".java";
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            }
            return this.updateResource(this.sourcesOutputDir.toPath(), fileName, code);
        }
        catch (IOError e) {
            throw new MojoFailureException("IOError with file " + fileName, (Throwable)e);
        }
    }

    public String capitalize(String str) {
        return Strings.capitalize((String)str);
    }

    public String uncapitalize(String str) {
        return StringUtils.uncapitalize((String)str);
    }

    public String xmlEncode(String str) {
        return JavadocHelper.xmlEncode((String)str);
    }

    public String javadoc(String indent, String doc) {
        StringBuilder sb = new StringBuilder(doc.length() * 2);
        sb.append("/**\n");
        int len = 78 - indent.length();
        String rem = this.xmlEncode(doc);
        while (!rem.isEmpty()) {
            int idx = rem.length() >= len ? rem.substring(0, len).lastIndexOf(32) : -1;
            int idx2 = rem.indexOf(10);
            if (idx2 >= 0 && (idx < 0 || idx2 < idx || idx2 < len)) {
                idx = idx2;
            }
            if (idx >= 0) {
                String s = rem.substring(0, idx);
                while (s.endsWith(" ")) {
                    s = s.substring(0, s.length() - 1);
                }
                String l = rem.substring(idx + 1);
                while (l.startsWith(" ")) {
                    l = l.substring(1);
                }
                sb.append(indent).append(" * ").append(s).append("\n");
                rem = l;
                continue;
            }
            sb.append(indent).append(" * ").append(rem).append("\n");
            rem = "";
        }
        sb.append(indent).append(" */");
        return sb.toString();
    }

    public String getMainDescriptionWithoutPathOptions(ComponentModel model) {
        return DslHelper.getMainDescriptionWithoutPathOptions(model);
    }

    public String toCamelCaseLower(String str) {
        return DslHelper.toCamelCaseLower(str);
    }

    public static Optional<ComponentModel.ComponentOptionModel> findConfiguration(Collection<ComponentModel.ComponentOptionModel> options) {
        return options.stream().filter(o -> o.getConfigurationField() != null).findFirst();
    }
}

