/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.spi.annotations.ExternalSchemaElement;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

@Mojo(name="generate-xml-parser", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ModelXmlParserGeneratorMojo
extends AbstractGeneratorMojo {
    public static final String PARSER_PACKAGE = "org.apache.camel.xml.in";
    public static final String MODEL_PACKAGE = "org.apache.camel.model";
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${camel-generate-xml-parser}")
    protected boolean generateXmlParser;
    private Class<?> outputDefinitionClass;

    @Inject
    public ModelXmlParserGeneratorMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    @Override
    public void execute(MavenProject project) throws MojoFailureException, MojoExecutionException {
        this.sourcesOutputDir = new File(project.getBasedir(), "src/generated/java");
        this.generateXmlParser = Boolean.parseBoolean(project.getProperties().getProperty("camel-generate-xml-parser", "false"));
        super.execute(project);
    }

    public void execute() throws MojoExecutionException {
        if (!this.generateXmlParser) {
            return;
        }
        Path javaDir = this.sourcesOutputDir.toPath();
        String parser = this.generateParser();
        this.updateResource(javaDir, "org.apache.camel.xml.in.ModelParser".replace('.', '/') + ".java", parser);
    }

    public String generateParser() throws MojoExecutionException {
        Index index;
        DynamicClassLoader classLoader;
        try {
            classLoader = DynamicClassLoader.createDynamicClassLoader(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
        }
        this.outputDefinitionClass = this.loadClass(classLoader, "org.apache.camel.model.OutputDefinition");
        String resName = this.outputDefinitionClass.getName().replace('.', '/') + ".class";
        String url = classLoader.getResource(resName).toExternalForm().replace(resName, "META-INF/jandex.idx");
        try (InputStream is = new URL(url).openStream();){
            index = new IndexReader(is).read();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
        List model = Stream.of(XmlRootElement.class, XmlEnum.class, XmlType.class).map(Class::getName).map(DotName::createSimple).map(arg_0 -> ((Index)index).getAnnotations(arg_0)).flatMap(Collection::stream).map(AnnotationInstance::target).map(AnnotationTarget::asClass).map(ClassInfo::name).map(DotName::toString).sorted().distinct().filter(n -> !n.equals("org.apache.camel.model.WhenSkipSendToEndpointDefinition")).map(name -> this.loadClass(classLoader, (String)name)).flatMap(this::references).flatMap(this::fieldReferences).distinct().toList();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("mojo", (Object)this);
        ctx.put("model", model.stream().map(x$0 -> new ClassWrapper((Class<?>)x$0)).toList());
        ctx.put("package", PARSER_PACKAGE);
        return this.velocity("velocity/model-parser.vm", ctx);
    }

    private Class<?> loadClass(ClassLoader loader, String name) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class " + name, e);
        }
    }

    private Stream<Class<?>> references(Class<?> clazz) {
        ArrayList allClasses = new ArrayList();
        for (Class<?> cl = clazz; cl != Object.class; cl = cl.getSuperclass()) {
            allClasses.add(cl);
        }
        return allClasses.stream();
    }

    private Stream<Class<?>> fieldReferences(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz), Stream.of(clazz.getDeclaredFields()).filter(f -> f.getAnnotation(XmlTransient.class) == null).map(f -> {
            if (f.getAnnotation(XmlJavaTypeAdapter.class) != null) {
                Class cl = f.getAnnotation(XmlJavaTypeAdapter.class).value();
                while (cl.getSuperclass() != XmlAdapter.class) {
                    cl = cl.getSuperclass();
                }
                return ((ParameterizedType)cl.getGenericSuperclass()).getActualTypeArguments()[0];
            }
            return f.getGenericType();
        }).map(GenericType::new).map(t -> t.getRawClass() == List.class ? t.getActualTypeArgument(0) : t).map(GenericType::getRawClass).filter(c -> c.getName().startsWith("org.apache.camel.")));
    }

    private Stream<? extends Member> findMethodsForClass(Class<?> c) {
        XmlAccessType accessType = c.getAnnotation(XmlAccessorType.class) != null && c != this.outputDefinitionClass ? c.getAnnotation(XmlAccessorType.class).value() : XmlAccessType.PUBLIC_MEMBER;
        if (accessType == XmlAccessType.FIELD || accessType == XmlAccessType.NONE) {
            return Stream.of(c.getDeclaredMethods()).filter(m -> m.getName().startsWith("set") && m.getParameterCount() == 1).filter(m -> m.getAnnotation(XmlAttribute.class) != null || m.getAnnotation(XmlElement.class) != null || m.getAnnotation(XmlElementRef.class) != null || m.getAnnotation(XmlValue.class) != null).sorted(Comparator.comparing(Method::getName));
        }
        return Stream.of(c.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) || accessType == XmlAccessType.PROPERTY).filter(m -> m.getName().startsWith("set") && m.getParameterCount() == 1).filter(m -> m.getAnnotation(XmlTransient.class) == null).sorted(Comparator.comparing(Method::getName));
    }

    private Stream<? extends Member> findFieldsForClass(Class<?> c) {
        XmlAccessType accessType = c.getAnnotation(XmlAccessorType.class) != null ? c.getAnnotation(XmlAccessorType.class).value() : XmlAccessType.PUBLIC_MEMBER;
        if (accessType == XmlAccessType.PROPERTY || accessType == XmlAccessType.NONE) {
            return Stream.of(c.getDeclaredFields()).filter(f -> f.getAnnotation(XmlAttribute.class) != null || f.getAnnotation(XmlElement.class) != null || f.getAnnotation(XmlElementRef.class) != null || f.getAnnotation(XmlValue.class) != null).sorted(Comparator.comparing(Field::getName));
        }
        return Stream.of(c.getDeclaredFields()).filter(f -> !Modifier.isTransient(f.getModifiers()) && !Modifier.isStatic(f.getModifiers())).filter(f -> Modifier.isPublic(f.getModifiers()) || accessType == XmlAccessType.FIELD).filter(f -> f.getAnnotation(XmlTransient.class) == null).sorted(Comparator.comparing(Field::getName));
    }

    public TreeMap<String, String> newTreeMap() {
        return new TreeMap<String, String>();
    }

    public String lowercase(String fn) {
        return fn.substring(0, 1).toLowerCase() + fn.substring(1);
    }

    public String uppercase(String fn) {
        return fn.substring(0, 1).toUpperCase() + fn.substring(1);
    }

    public void failure(String message) {
        throw new RuntimeException(message);
    }

    public ClassWrapper wrap(Class<?> clazz) {
        return new ClassWrapper(clazz);
    }

    public class ClassWrapper {
        private final Class<?> clazz;

        public ClassWrapper(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String getName() {
            return this.clazz.getName();
        }

        public String getSimpleName() {
            return this.clazz.getSimpleName();
        }

        public String getPackageName() {
            return this.clazz.getPackageName();
        }

        public ClassWrapper getSuperclass() {
            return this.clazz.getSuperclass() != null ? new ClassWrapper(this.clazz.getSuperclass()) : null;
        }

        public boolean isAssignableFrom(ClassWrapper wrapper) {
            return this.clazz.isAssignableFrom(wrapper.clazz);
        }

        public GenericType getSuperclassType() {
            return this.clazz.getGenericSuperclass() != null ? new GenericType(this.clazz.getGenericSuperclass()) : null;
        }

        public boolean isInterface() {
            return this.clazz.isInterface();
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.clazz.getModifiers());
        }

        public XmlEnum getXmlEnum() {
            return this.clazz.getAnnotation(XmlEnum.class);
        }

        public XmlRootElement getXmlRootElement() {
            return this.clazz.getAnnotation(XmlRootElement.class);
        }

        public List<MemberWrapper> getAttributes() {
            return this.getMembers().filter(m -> m.getXmlAttribute() != null).sorted(Comparator.comparing(MemberWrapper::getName)).toList();
        }

        public List<MemberWrapper> getElements() {
            return this.getMembers().filter(m -> m.getXmlAttribute() == null && m.getXmlAnyAttribute() == null && m.getXmlValue() == null).sorted(Comparator.comparing(MemberWrapper::getName)).toList();
        }

        public Optional<MemberWrapper> getValue() {
            return this.getMembers().filter(m -> m.getXmlValue() != null).findAny();
        }

        private Stream<MemberWrapper> getMembers() {
            return Stream.concat(ModelXmlParserGeneratorMojo.this.findFieldsForClass(this.clazz), ModelXmlParserGeneratorMojo.this.findMethodsForClass(this.clazz)).map(x$0 -> new MemberWrapper((Member)x$0)).filter(m -> this.clazz == ModelXmlParserGeneratorMojo.this.outputDefinitionClass || !ModelXmlParserGeneratorMojo.this.outputDefinitionClass.isAssignableFrom(this.clazz) || !m.member.getName().equals("setOutputs"));
        }

        public List<ClassWrapper> getClassAndSuper() {
            return this.doGetClassAndSuper().toList();
        }

        private Stream<ClassWrapper> doGetClassAndSuper() {
            return this.clazz != Object.class && this.clazz != null ? Stream.concat(Stream.of(this), this.getSuperclass().doGetClassAndSuper()) : Stream.empty();
        }

        public Class<?> getWrappedClass() {
            return this.clazz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassWrapper that = (ClassWrapper)o;
            return Objects.equals(this.clazz, that.clazz);
        }

        public int hashCode() {
            return Objects.hash(this.clazz);
        }
    }

    public class MemberWrapper {
        private final Member member;

        public MemberWrapper(Member member) {
            this.member = member;
        }

        public ClassWrapper getDeclaringClass() {
            return new ClassWrapper(this.member.getDeclaringClass());
        }

        public XmlAttribute getXmlAttribute() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlAttribute.class);
        }

        public XmlAnyAttribute getXmlAnyAttribute() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlAnyAttribute.class);
        }

        public XmlValue getXmlValue() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlValue.class);
        }

        public XmlTransient getXmlTransient() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlTransient.class);
        }

        public XmlElementRef getXmlElementRef() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlElementRef.class);
        }

        public XmlElements getXmlElements() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlElements.class);
        }

        public XmlElement getXmlElement() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlElement.class);
        }

        public XmlElementWrapper getXmlElementWrapper() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlElementWrapper.class);
        }

        public XmlJavaTypeAdapter getXmlJavaTypeAdapter() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlJavaTypeAdapter.class);
        }

        public XmlAnyElement getXmlAnyElement() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(XmlAnyElement.class);
        }

        public ExternalSchemaElement getExternalSchemaElement() {
            return ((AnnotatedElement)((Object)this.member)).getAnnotation(ExternalSchemaElement.class);
        }

        public GenericType getType() {
            return new GenericType(this.member instanceof Method ? ((Method)this.member).getGenericParameterTypes()[0] : ((Field)this.member).getGenericType());
        }

        public String getName() {
            String aname;
            String name = null;
            XmlAttribute attr = this.getXmlAttribute();
            if (attr != null && !"##default".equals(aname = attr.name())) {
                name = aname;
            }
            if (name == null) {
                String mn = this.member.getName();
                name = this.member instanceof Method ? ModelXmlParserGeneratorMojo.this.lowercase(mn.substring(3)) : mn;
            }
            return name;
        }

        public String getSetter() {
            String mn = this.member.getName();
            return this.member instanceof Method ? mn : "set" + ModelXmlParserGeneratorMojo.this.uppercase(mn);
        }

        public String getGetter() {
            return "g" + this.getSetter().substring(1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberWrapper that = (MemberWrapper)o;
            return Objects.equals(this.member, that.member);
        }

        public int hashCode() {
            return Objects.hash(this.member);
        }
    }
}

