/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl.component;

import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.commons.lang3.StringUtils;

public final class ComponentDslInnerImplBuilderGenerator {
    private static final String BUILDER_IMPL_SUFFIX = "Impl";
    private final JavaClass javaClass;
    private final ComponentModel componentModel;
    private final String classBuilderName;

    private ComponentDslInnerImplBuilderGenerator(JavaClass javaClass, ComponentModel componentModel, String interfaceBuilderName) {
        this.javaClass = javaClass;
        this.componentModel = componentModel;
        this.classBuilderName = interfaceBuilderName;
        this.generateJavaClass();
    }

    public static ComponentDslInnerImplBuilderGenerator generateClass(JavaClass javaClass, ComponentModel componentModel, String classBuilderName) {
        return new ComponentDslInnerImplBuilderGenerator(javaClass, componentModel, classBuilderName);
    }

    public String getGeneratedClassName() {
        return this.classBuilderName + BUILDER_IMPL_SUFFIX;
    }

    private void generateJavaClass() {
        this.setClassNameAndType();
        this.setMethods();
    }

    private void setClassNameAndType() {
        this.javaClass.setName(this.getGeneratedClassName()).setPackagePrivate().setStatic(false).extendSuperType(String.format("AbstractComponentBuilder<%s>", this.componentModel.getShortJavaType())).implementInterface(this.classBuilderName);
    }

    private void setMethods() {
        this.javaClass.addMethod().setProtected().setReturnType(this.componentModel.getShortJavaType()).setName("buildConcreteComponent").setBody(String.format("return new %s();", this.componentModel.getShortJavaType())).addAnnotation(Override.class);
        this.javaClass.addMethod().setProtected().setReturnType("boolean").setName("setPropertyOnComponent").addParameter("Component", "component").addParameter(String.class, "name").addParameter(Object.class, "value").setBody(this.generatePropertiesSetters(this.componentModel)).addAnnotation(Override.class);
    }

    private String generatePropertiesSetters(ComponentModel componentModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("switch (name) {\n");
        componentModel.getComponentOptions().forEach(componentOptionModel -> {
            String setterAsString = String.format("case \"%s\": ((%s) component).set%s((%s) value); return true;\n", componentOptionModel.getName(), componentModel.getShortJavaType(), StringUtils.capitalize((String)componentOptionModel.getName()), componentOptionModel.getJavaType());
            stringBuilder.append(setterAsString);
        });
        stringBuilder.append("default: return false;\n}");
        return stringBuilder.toString();
    }
}

