/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

@Mojo(name="xref-check", threadSafe=true)
public class XRefCheckMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List<String> unresolved = this.checkXRef(this.project.getBasedir().toPath());
            if (!unresolved.isEmpty()) {
                this.getLog().error((CharSequence)"Unresolved xrefs:");
                for (String ref : unresolved) {
                    this.getLog().error((CharSequence)("  " + ref));
                }
                throw new MojoFailureException("Unresolved xrefs");
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error checking xref", (Throwable)e);
        }
    }

    public List<String> checkXRef(Path path) throws IOException {
        Map site;
        ArrayList<String> unresolved = new ArrayList<String>();
        Load yaml = new Load(LoadSettings.builder().build());
        BufferedReader r = Files.newBufferedReader(path.resolve("site.yml"));
        Object object = null;
        try {
            site = (Map)yaml.loadFromReader((Reader)r);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (r != null) {
                if (object != null) {
                    try {
                        ((Reader)r).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((Reader)r).close();
                }
            }
        }
        HashMap<String, Path> pages = new HashMap<String, Path>();
        for (Map component : (List)((Map)site.get("content")).get("sources")) {
            Map antora;
            String url = (String)component.get("url");
            String startPath = (String)component.get("start_path");
            Path root = path.resolve(url).resolve(startPath).normalize();
            try (BufferedReader r2 = Files.newBufferedReader(root.resolve("antora.yml"));){
                antora = (Map)yaml.loadFromReader((Reader)r2);
            }
            String name = (String)antora.get("name");
            List navs = ((List)antora.get("nav")).stream().map(root::resolve).collect(Collectors.toList());
            for (Path nav : navs) {
                pages.put(name + "::" + nav.getFileName().toString(), nav);
            }
            Files.list(root.resolve("modules")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> Files.isDirectory(p.resolve("pages"), new LinkOption[0])).forEach(module -> {
                Path pagesDir = module.resolve("pages");
                this.walk(pagesDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(page -> {
                    Path rel = pagesDir.relativize((Path)page);
                    pages.put(name + "::" + rel.toString(), (Path)page);
                });
            });
        }
        Pattern xref = Pattern.compile("\\b(?<all>xref:(?<link>[^\\[]+.adoc)\\[[^\\]]*\\])");
        for (Map.Entry page : pages.entrySet()) {
            String str = PackageHelper.loadText((Path)((Path)page.getValue()));
            Matcher m = xref.matcher(str);
            while (m.find()) {
                String link = m.group("link");
                String all = m.group("all");
                if (!link.contains("::")) {
                    link = ((String)page.getKey()).substring(0, ((String)page.getKey()).indexOf("::")) + "::" + link;
                }
                if (pages.containsKey(link)) continue;
                long line = str.chars().limit(m.start()).filter(c -> c == 10).count() + 1L;
                unresolved.add((String)page.getKey() + " (" + page.getValue() + ") at line " + line + ": " + all);
            }
        }
        return unresolved;
    }

    private Stream<Path> walk(Path p) {
        try {
            return Files.walk(p, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

