/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="prepare-catalog-karaf", threadSafe=true)
public class PrepareCatalogKarafMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/karaf/components")
    protected File componentsOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/karaf/dataformats")
    protected File dataFormatsOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/karaf/languages")
    protected File languagesOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/karaf/others")
    protected File othersOutDir;
    @Parameter(defaultValue="${project.build.directory}/../../../platforms/karaf/features/src/main/resources/")
    protected File featuresDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-core-engine")
    protected File coreDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-base")
    protected File baseDir;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<String> features = this.findKarafFeatures();
        this.executeComponents(features);
        this.executeDataFormats(features);
        this.executeLanguages(features);
        this.executeOthers(features);
    }

    protected void executeComponents(Set<String> features) throws MojoExecutionException, MojoFailureException {
        File[] components;
        this.getLog().info((CharSequence)"Copying all Camel component json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> componentFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (components = this.componentsDir.listFiles()) != null) {
            for (File dir : components) {
                if (!dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                if (!features.contains(dir.getName())) continue;
                if ("camel-as2".equals(dir.getName())) {
                    target = new File(dir, "camel-as2-component/target/classes");
                } else if ("camel-box".equals(dir.getName())) {
                    target = new File(dir, "camel-box-component/target/classes");
                } else if ("camel-salesforce".equals(dir.getName())) {
                    target = new File(dir, "camel-salesforce-component/target/classes");
                } else if ("camel-servicenow".equals(dir.getName())) {
                    target = new File(dir, "camel-servicenow-component/target/classes");
                } else {
                    boolean active;
                    File src = new File(dir, "src");
                    boolean bl = active = src.isDirectory() && src.exists();
                    if (!active) continue;
                }
                this.findComponentFilesRecursive(target, jsonFiles, componentFiles, new CamelComponentsFileFilter());
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            this.findComponentFilesRecursive(target, jsonFiles, componentFiles, new CamelComponentsFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + componentFiles.size() + " component.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " component json files"));
        Path outDir = this.componentsOutDir.toPath();
        PrepareCatalogKarafMojo.copyFiles(outDir, jsonFiles);
        PrepareCatalogKarafMojo.generateJsonList(outDir, "../components.properties");
    }

    protected void executeDataFormats(Set<String> features) throws MojoExecutionException, MojoFailureException {
        File[] dataFormats;
        this.getLog().info((CharSequence)"Copying all Camel dataformat json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (dataFormats = this.componentsDir.listFiles()) != null) {
            for (File dir : dataFormats) {
                boolean active;
                if (!dir.isDirectory() || "target".equals(dir.getName()) || !features.contains(dir.getName())) continue;
                File src = new File(dir, "src");
                boolean bl = active = src.isDirectory() && src.exists();
                if (!active) continue;
                File target = new File(dir, "target/classes");
                this.findDataFormatFilesRecursive(target, jsonFiles, dataFormatFiles, new CamelDataFormatsFileFilter());
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            this.findDataFormatFilesRecursive(target, jsonFiles, dataFormatFiles, new CamelDataFormatsFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + dataFormatFiles.size() + " dataformat.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " dataformat json files"));
        Path outDir = this.dataFormatsOutDir.toPath();
        PrepareCatalogKarafMojo.copyFiles(outDir, jsonFiles);
        PrepareCatalogKarafMojo.generateJsonList(outDir, "../dataformats.properties");
    }

    protected void executeLanguages(Set<String> features) throws MojoExecutionException, MojoFailureException {
        File[] languages;
        this.getLog().info((CharSequence)"Copying all Camel language json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> languageFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (languages = this.componentsDir.listFiles()) != null) {
            for (File dir : languages) {
                boolean active;
                if (!features.contains(dir.getName()) && !dir.getName().equals("camel-bean") && !dir.getName().equals("camel-xpath")) continue;
                File src = new File(dir, "src");
                boolean bl = active = src.isDirectory() && src.exists();
                if (!active || !dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                this.findLanguageFilesRecursive(target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
            }
        }
        if (this.baseDir != null && this.baseDir.isDirectory()) {
            File target = new File(this.baseDir, "target/classes");
            this.findLanguageFilesRecursive(target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
            target = new File(this.baseDir, "../camel-xml-jaxp/target/classes");
            this.findLanguageFilesRecursive(target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + languageFiles.size() + " language.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " language json files"));
        Path outDir = this.languagesOutDir.toPath();
        PrepareCatalogKarafMojo.copyFiles(outDir, jsonFiles);
        PrepareCatalogKarafMojo.generateJsonList(outDir, "../languages.properties");
    }

    protected void executeOthers(Set<String> features) throws MojoExecutionException, MojoFailureException {
        File[] others;
        this.getLog().info((CharSequence)"Copying all Camel other json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> otherFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (others = this.componentsDir.listFiles()) != null) {
            for (File dir : others) {
                boolean active;
                if (!features.contains(dir.getName())) continue;
                boolean special = "camel-core-osgi".equals(dir.getName()) || "camel-core-xml".equals(dir.getName()) || "camel-http-base".equals(dir.getName()) || "camel-http-common".equals(dir.getName()) || "camel-jetty-common".equals(dir.getName());
                boolean special2 = "camel-as2".equals(dir.getName()) || "camel-box".equals(dir.getName()) || "camel-olingo2".equals(dir.getName()) || "camel-olingo4".equals(dir.getName()) || "camel-servicenow".equals(dir.getName()) || "camel-salesforce".equals(dir.getName());
                boolean special3 = "camel-debezium-common".equals(dir.getName());
                if (special || special2 || special3) continue;
                File src = new File(dir, "src");
                boolean bl = active = src.isDirectory() && src.exists();
                if (!active || !dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                this.findOtherFilesRecursive(target, jsonFiles, otherFiles, new CamelOthersFileFilter());
            }
        }
        this.getLog().info((CharSequence)("Found " + otherFiles.size() + " other.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " other json files"));
        Path outDir = this.othersOutDir.toPath();
        PrepareCatalogKarafMojo.copyFiles(outDir, jsonFiles);
        PrepareCatalogKarafMojo.generateJsonList(outDir, "../others.properties");
    }

    private void findComponentFilesRecursive(File dir, Set<File> found, Set<File> components, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean componentFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = componentFile = !rootDir && file.isFile() && file.getName().equals("component.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (componentFile) {
                    components.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findComponentFilesRecursive(file, found, components, filter);
            }
        }
    }

    private void findDataFormatFilesRecursive(File dir, Set<File> found, Set<File> dataFormats, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean dataFormatFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = dataFormatFile = !rootDir && file.isFile() && file.getName().equals("dataformat.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (dataFormatFile) {
                    dataFormats.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findDataFormatFilesRecursive(file, found, dataFormats, filter);
            }
        }
    }

    private void findLanguageFilesRecursive(File dir, Set<File> found, Set<File> languages, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean languageFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = languageFile = !rootDir && file.isFile() && file.getName().equals("language.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (languageFile) {
                    languages.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findLanguageFilesRecursive(file, found, languages, filter);
            }
        }
    }

    private void findOtherFilesRecursive(File dir, Set<File> found, Set<File> others, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean otherFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = otherFile = !rootDir && file.isFile() && file.getName().equals("other.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (otherFile) {
                    others.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findOtherFilesRecursive(file, found, others, filter);
            }
        }
    }

    public static void copyFiles(Path outDir, Collection<File> files) throws MojoFailureException {
        for (File file : files) {
            Path to = outDir.resolve(file.getName());
            try {
                FileUtil.updateFile((Path)file.toPath(), (Path)to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
    }

    public static Set<String> generateJsonList(Path outDir, String outFile) throws MojoFailureException {
        Path all = outDir.resolve(outFile);
        try {
            Set answer = Files.list(outDir).filter(p -> p.getFileName().toString().endsWith(".json")).map(p -> p.getFileName().toString()).map(n -> n.substring(0, n.length() - ".json".length())).sorted().collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
            String data = String.join((CharSequence)"\n", answer) + "\n";
            FileUtil.updateFile((Path)all, (String)data);
            return answer;
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        FileUtil.updateFile((Path)from.toPath(), (Path)to.toPath());
    }

    private Set<String> findKarafFeatures() throws MojoExecutionException, MojoFailureException {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        File file = new File(this.featuresDir, "features.xml");
        try (FileInputStream is = new FileInputStream(file);){
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(false);
            dbf.setValidating(false);
            dbf.setXIncludeAware(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            Document dom = dbf.newDocumentBuilder().parse(is);
            NodeList children = dom.getElementsByTagName("features");
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                NodeList children2 = child.getChildNodes();
                for (int j = 0; j < children2.getLength(); ++j) {
                    String artifactId;
                    Node child2 = children2.item(j);
                    if (!"feature".equals(child2.getNodeName()) || (artifactId = child2.getAttributes().getNamedItem("name").getTextContent()) == null || !artifactId.startsWith("camel-")) continue;
                    answer.add(artifactId);
                }
            }
            this.getLog().info((CharSequence)("Found " + answer.size() + " Camel features in file: " + file));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading features.xml file", e);
        }
        return answer;
    }

    private static class CamelOthersFileFilter
    implements FileFilter {
        private CamelOthersFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText((File)pathname);
                    return "other".equals(PackageHelper.getSchemaKind((String)json));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("other.properties");
        }
    }

    private static class CamelLanguagesFileFilter
    implements FileFilter {
        private CamelLanguagesFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText((File)pathname);
                    return "language".equals(PackageHelper.getSchemaKind((String)json));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("language.properties");
        }
    }

    private static class CamelDataFormatsFileFilter
    implements FileFilter {
        private CamelDataFormatsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText((File)pathname);
                    return "dataformat".equals(PackageHelper.getSchemaKind((String)json));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("dataformat.properties");
        }
    }

    private static class CamelComponentsFileFilter
    implements FileFilter {
        private CamelComponentsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText((File)pathname);
                    return "component".equals(PackageHelper.getSchemaKind((String)json));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("component.properties");
        }
    }
}

