/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

@Mojo(name="prepare-main", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PrepareCamelMainMojo
extends AbstractGeneratorMojo {
    @Parameter(readonly=true, defaultValue="${project.basedir}/src/generated/resources")
    protected File outFolder;
    @Parameter(readonly=true, defaultValue="${project.build.directory}/")
    protected File buildDir;
    @Parameter(defaultValue="${camel-generate-main}")
    protected boolean generateMain;

    public static List<MainModel.MainOptionModel> parseConfigurationSource(String fileName) throws IOException {
        return PrepareCamelMainMojo.parseConfigurationSource(new File(fileName));
    }

    public static List<MainModel.MainOptionModel> parseConfigurationSource(File file) throws IOException {
        ArrayList<MainModel.MainOptionModel> answer = new ArrayList<MainModel.MainOptionModel>();
        JavaClassSource clazz = (JavaClassSource)Roaster.parse((File)file);
        List<FieldSource> fields = clazz.getFields();
        fields = fields.stream().filter(f -> !f.isFinal() && !f.isStatic()).collect(Collectors.toList());
        fields.forEach(f -> {
            String name = f.getName();
            String javaType = f.getType().getQualifiedName();
            String sourceType = clazz.getQualifiedName();
            String defaultValue = f.getStringInitializer();
            String setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            MethodSource setter = clazz.getMethod(setterName, new String[]{javaType});
            if (setter != null) {
                String desc = setter.getJavaDoc().getFullText();
                boolean deprecated = setter.getAnnotation(Deprecated.class) != null;
                String type = PrepareCamelMainMojo.fromMainToType(javaType);
                MainModel.MainOptionModel model = new MainModel.MainOptionModel();
                model.setName(name);
                model.setType(type);
                model.setJavaType(javaType);
                model.setDescription(JavadocHelper.sanitizeDescription((String)desc, (boolean)false));
                model.setSourceType(sourceType);
                model.setDefaultValue(PrepareCamelMainMojo.asDefaultValue(type, defaultValue));
                model.setDeprecated(deprecated);
                List<String> enums = null;
                if ("org.apache.camel.LoggingLevel".equals(javaType)) {
                    enums = Arrays.asList("ERROR,WARN,INFO,DEBUG,TRACE,OFF".split(","));
                } else if ("org.apache.camel.ManagementStatisticsLevel".equals(javaType)) {
                    enums = Arrays.asList("Extended,Default,RoutesOnly,Off".split(","));
                } else if ("org.apache.camel.spi.RestBindingMode".equals(javaType)) {
                    enums = Arrays.asList("auto,off,json,xml,json_xml".split(","));
                } else if ("org.apache.camel.spi.RestHostNameResolver".equals(javaType)) {
                    enums = Arrays.asList("allLocalIp,localIp,localHostName".split(","));
                }
                model.setEnums(enums);
                answer.add(model);
            }
        });
        return answer;
    }

    private static String fromMainToType(String type) {
        if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
            return "boolean";
        }
        if ("int".equals(type) || "java.lang.Integer".equals(type)) {
            return "integer";
        }
        if ("long".equals(type) || "java.lang.Long".equals(type)) {
            return "integer";
        }
        if ("float".equals(type) || "java.lang.Float".equals(type)) {
            return "number";
        }
        if ("double".equals(type) || "java.lang.Double".equals(type)) {
            return "number";
        }
        if ("string".equals(type) || "java.lang.String".equals(type)) {
            return "string";
        }
        return "object";
    }

    private static Object asDefaultValue(String type, String defaultValue) {
        if (defaultValue != null) {
            if ("boolean".equals(type)) {
                return Boolean.parseBoolean(defaultValue);
            }
            if ("integer".equals(type)) {
                return Integer.parseInt(defaultValue);
            }
        }
        return defaultValue;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MainModel model;
        File[] files;
        if (!this.generateMain) {
            return;
        }
        ArrayList<MainModel.MainOptionModel> data = new ArrayList<MainModel.MainOptionModel>();
        for (File file : files = new File(this.project.getBasedir(), "src/main/java/org/apache/camel/main").listFiles(f -> f.isFile() && f.getName().endsWith("Properties.java"))) {
            this.getLog().info((CharSequence)("Parsing Camel Main configuration file: " + file));
            try {
                List<MainModel.MainOptionModel> model2 = PrepareCamelMainMojo.parseConfigurationSource(file);
                String prefix = file.getName().contains("Hystrix") ? "camel.hystrix." : (file.getName().contains("Resilience") ? "camel.resilience4j." : (file.getName().contains("Rest") ? "camel.rest." : "camel.main."));
                String namePrefix = prefix;
                model2.forEach(m -> m.setName(namePrefix + m.getName()));
                data.addAll(model2);
            }
            catch (Exception e) {
                throw new MojoFailureException("Error parsing file " + file + " due " + e.getMessage(), (Throwable)e);
            }
        }
        File restConfig = new File(this.buildDir, "../../camel-api/src/main/java/org/apache/camel/spi/RestConfiguration.java");
        try {
            model = PrepareCamelMainMojo.parseConfigurationSource(restConfig);
            model.forEach(m -> m.setName("camel.rest." + m.getName()));
            data.addAll((Collection<MainModel.MainOptionModel>)model);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error parsing file " + restConfig + " due " + e.getMessage(), (Throwable)e);
        }
        data.sort((o1, o2) -> {
            if (o1.getName().startsWith("camel.main.") && !o2.getName().startsWith("camel.main.")) {
                return -1;
            }
            if (!o1.getName().startsWith("camel.main.") && o2.getName().startsWith("camel.main.")) {
                return 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        });
        if (!data.isEmpty()) {
            model = new MainModel();
            model.getOptions().addAll(data);
            model.getGroups().add(new MainModel.MainGroupModel("camel.main", "camel-main configurations.", "org.apache.camel.main.DefaultConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.hystrix", "camel-hystrix configurations.", "org.apache.camel.main.HystrixConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.resilience4j", "camel-resilience4j configurations.", "org.apache.camel.main.Resilience4jConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.rest", "camel-rest configurations.", "org.apache.camel.spi.RestConfiguration"));
            String json = JsonMapper.createJsonSchema((MainModel)model);
            this.updateResource(this.outFolder.toPath(), "META-INF/camel-main-configuration-metadata.json", json);
        }
    }
}

