/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Properties;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public class PackageComponentMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File componentOutDir;
    private MavenProjectHelper projectHelper;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageComponentMojo.prepareComponent(this.getLog(), this.project, this.projectHelper, this.componentOutDir, this.buildContext);
    }

    public static void prepareComponent(Log log, MavenProject project, MavenProjectHelper projectHelper, File componentOutDir, BuildContext buildContext) throws MojoExecutionException {
        File camelMetaDir = new File(componentOutDir, "META-INF/services/org/apache/camel/");
        if (projectHelper != null) {
            projectHelper.addResource(project, componentOutDir.getPath(), Collections.singletonList("**/component.properties"), Collections.emptyList());
        }
        if (!PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/component")) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (Resource r : project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/component")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                ++count;
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(name);
            }
        }
        if (count > 0) {
            Properties properties = new Properties();
            String names = buffer.toString();
            properties.put("components", names);
            properties.put("groupId", project.getGroupId());
            properties.put("artifactId", project.getArtifactId());
            properties.put("version", project.getVersion());
            properties.put("projectName", project.getName());
            if (project.getDescription() != null) {
                properties.put("projectDescription", project.getDescription());
            }
            camelMetaDir.mkdirs();
            File outFile = new File(camelMetaDir, "component.properties");
            if (outFile.exists()) {
                try {
                    Properties existing = new Properties();
                    FileInputStream is = new FileInputStream(outFile);
                    existing.load(is);
                    ((InputStream)is).close();
                    if (existing.equals(properties)) {
                        log.debug((CharSequence)"No component changes detected");
                        return;
                    }
                }
                catch (IOException existing) {
                    // empty catch block
                }
            }
            try {
                OutputStream os = buildContext.newFileOutputStream(outFile);
                properties.store(os, "Generated by camel-package-maven-plugin");
                os.close();
                log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "components: " : "component: ") + names));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write properties to " + outFile + ". Reason: " + e, (Exception)e);
            }
        }
        log.debug((CharSequence)"No META-INF/services/org/apache/camel/component directory found. Are you sure you have created a Camel component?");
    }
}

