/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.model.ComponentModel;
import org.apache.camel.maven.packaging.model.ComponentOptionModel;
import org.apache.camel.maven.packaging.model.DataFormatModel;
import org.apache.camel.maven.packaging.model.DataFormatOptionModel;
import org.apache.camel.maven.packaging.model.EipModel;
import org.apache.camel.maven.packaging.model.EipOptionModel;
import org.apache.camel.maven.packaging.model.EndpointOptionModel;
import org.apache.camel.maven.packaging.model.LanguageModel;
import org.apache.camel.maven.packaging.model.LanguageOptionModel;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mvel2.templates.TemplateRuntime;
import org.sonatype.plexus.build.incremental.BuildContext;

public class UpdateReadmeMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File buildDir;
    protected File docDir;
    protected File eipDocDir;
    protected Boolean failFast;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeComponent();
        this.executeDataFormat();
        this.executeLanguage();
        this.executeEips();
    }

    private void executeComponent() throws MojoExecutionException, MojoFailureException {
        List<String> componentNames = this.findComponentNames();
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            for (String componentName : componentNames) {
                String json = this.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                componentName = UpdateReadmeMojo.asComponentName(componentName);
                File file = new File(this.docDir, componentName + "-component.adoc");
                ComponentModel model = this.generateComponentModel(componentName, json);
                String title = UpdateReadmeMojo.asComponentTitle(model.getScheme(), model.getTitle());
                model.setTitle(title);
                if (!StringHelper.isEmpty(model.getAlternativeSchemes())) {
                    String first = model.getAlternativeSchemes().split(",")[0];
                    if (!model.getScheme().equals(first)) continue;
                }
                String docTitle = model.getTitle() + " Component";
                boolean deprecated = "true".equals(model.getDeprecated());
                if (deprecated) {
                    docTitle = docTitle + " (deprecated)";
                }
                boolean exists = file.exists();
                boolean updated = this.updateTitles(file, docTitle);
                updated |= this.updateAvailableFrom(file, model.getFirstVersion());
                boolean hasOptions = model.getComponentOptions().stream().anyMatch(o -> !o.getName().equals("resolvePropertyPlaceholders"));
                if (!hasOptions) {
                    model.getComponentOptions().clear();
                }
                String options = this.templateComponentOptions(model);
                updated |= this.updateComponentOptions(file, options);
                options = this.templateEndpointOptions(model);
                if (updated |= this.updateEndpointOptions(file, options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No component doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private void executeDataFormat() throws MojoExecutionException, MojoFailureException {
        List<String> dataFormatNames = this.findDataFormatNames();
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!dataFormatNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + dataFormatNames.size() + " dataformats"));
            for (String dataFormatName : dataFormatNames) {
                String json = this.loadDataFormatJson(jsonFiles, dataFormatName);
                if (json == null) continue;
                dataFormatName = UpdateReadmeMojo.asDataFormatName(dataFormatName);
                File file = new File(this.docDir, dataFormatName + "-dataformat.adoc");
                DataFormatModel model = this.generateDataFormatModel(dataFormatName, json);
                String title = UpdateReadmeMojo.asDataFormatTitle(model.getName(), model.getTitle());
                model.setTitle(title);
                String docTitle = model.getTitle() + " DataFormat";
                boolean deprecated = "true".equals(model.getDeprecated());
                if (deprecated) {
                    docTitle = docTitle + " (deprecated)";
                }
                boolean exists = file.exists();
                boolean updated = this.updateTitles(file, docTitle);
                updated |= this.updateAvailableFrom(file, model.getFirstVersion());
                String options = this.templateDataFormatOptions(model);
                if (updated |= this.updateDataFormatOptions(file, options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No dataformat doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private static String asComponentName(String name) {
        if (name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps")) {
            return "mail";
        }
        return name;
    }

    private void executeLanguage() throws MojoExecutionException, MojoFailureException {
        List<String> languageNames = this.findLanguageNames();
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!languageNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + languageNames.size() + " languages"));
            for (String languageName : languageNames) {
                String json = this.loadLanguageJson(jsonFiles, languageName);
                if (json == null) continue;
                File file = new File(this.docDir, languageName + "-language.adoc");
                LanguageModel model = this.generateLanguageModel(languageName, json);
                String docTitle = model.getTitle() + " Language";
                boolean deprecated = "true".equals(model.getDeprecated());
                if (deprecated) {
                    docTitle = docTitle + " (deprecated)";
                }
                boolean exists = file.exists();
                boolean updated = this.updateTitles(file, docTitle);
                updated |= this.updateAvailableFrom(file, model.getFirstVersion());
                String options = this.templateLanguageOptions(model);
                if (updated |= this.updateLanguageOptions(file, options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No language doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private void executeEips() throws MojoExecutionException, MojoFailureException {
        String currentDir = Paths.get(".", new String[0]).normalize().toAbsolutePath().toString();
        if (!currentDir.endsWith("camel-core")) {
            return;
        }
        TreeSet<File> jsonFiles = new TreeSet<File>();
        File coreDir = new File(".");
        if (coreDir.isDirectory()) {
            File target = new File(coreDir, "target/classes/org/apache/camel/model");
            PackageHelper.findJsonFiles(target, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        }
        if (!jsonFiles.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + jsonFiles.size() + " eips"));
            for (File jsonFile : jsonFiles) {
                String json = this.loadEipJson(jsonFile);
                if (json == null) continue;
                EipModel model = this.generateEipModel(json);
                String title = UpdateReadmeMojo.asEipTitle(model.getName(), model.getTitle());
                model.setTitle(title);
                String eipName = model.getName();
                if (!model.getLabel().startsWith("eip")) continue;
                File file = new File(this.eipDocDir, eipName + "-eip.adoc");
                String docTitle = model.getTitle() + " EIP";
                boolean deprecated = model.isDeprecated();
                if (deprecated) {
                    docTitle = docTitle + " (deprecated)";
                }
                boolean exists = file.exists();
                boolean updated = this.updateTitles(file, docTitle);
                String options = this.templateEipOptions(model);
                if (updated |= this.updateEipOptions(file, options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No eip doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private static String asComponentTitle(String name, String title) {
        if (name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps")) {
            return "Mail";
        }
        return title;
    }

    private static String asDataFormatName(String name) {
        if (name.startsWith("bindy")) {
            return "bindy";
        }
        return name;
    }

    private static String asEipName(String name) {
        return name;
    }

    private static String asDataFormatTitle(String name, String title) {
        if (name.startsWith("bindy")) {
            return "Bindy";
        }
        return title;
    }

    private static String asEipTitle(String name, String title) {
        return title;
    }

    private boolean updateTitles(File file, String title) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        boolean updated = false;
        try {
            ArrayList<String> newLines = new ArrayList<String>();
            String text = PackageHelper.loadText(new FileInputStream(file));
            String[] lines = text.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i == 0) {
                    String newLine = "## " + title;
                    newLines.add(newLine);
                    updated = !line.equals(newLine);
                    continue;
                }
                if (line.startsWith("^^^") || line.startsWith("~~~") || line.startsWith("+++")) {
                    String level = line.startsWith("+++") ? "####" : "###";
                    int idx = newLines.size() - 1;
                    String prev = (String)newLines.get(idx);
                    newLines.set(idx, level + " " + prev);
                    idx = newLines.size() - 2;
                    if (idx >= 0 && (prev = (String)newLines.get(idx)).startsWith("[[")) {
                        newLines.remove(idx);
                    }
                    updated = true;
                    continue;
                }
                newLines.add(line);
            }
            if (updated) {
                String newText = newLines.stream().collect(Collectors.joining("\n"));
                PackageHelper.writeText(file, newText);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        return updated;
    }

    private boolean updateAvailableFrom(File file, String firstVersion) throws MojoExecutionException {
        if (firstVersion == null || !file.exists()) {
            return false;
        }
        String[] parts = firstVersion.split("\\.");
        if (parts.length == 3 && parts[2].equals("0")) {
            firstVersion = parts[0] + "." + parts[1];
        }
        boolean updated = false;
        try {
            String newLine;
            String text = PackageHelper.loadText(new FileInputStream(file));
            String[] lines = text.split("\n");
            ArrayList<String> newLines = new ArrayList<String>();
            newLines.addAll(Arrays.asList(lines));
            boolean title = lines[0].startsWith("##");
            boolean empty = lines[1].trim().isEmpty();
            boolean availableFrom = lines[2].trim().contains("Available as of") || lines[2].trim().contains("Available in");
            boolean empty2 = lines[3].trim().isEmpty();
            if (title && empty && availableFrom) {
                newLine = "*Available as of Camel version " + firstVersion + "*";
                if (!newLine.equals(lines[2])) {
                    newLines.set(2, newLine);
                    updated = true;
                }
                if (!empty2) {
                    newLines.add(3, "");
                    updated = true;
                }
            } else if (!availableFrom) {
                newLine = "*Available as of Camel version " + firstVersion + "*";
                newLines.add(2, newLine);
                newLines.add(3, "");
                updated = true;
            }
            if (updated) {
                String newText = newLines.stream().collect(Collectors.joining("\n"));
                PackageHelper.writeText(file, newText);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        return updated;
    }

    private boolean updateComponentOptions(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// component options: START", "// component options: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// component options: START");
                String after = StringHelper.after(text, "// component options: END");
                text = before + "// component options: START\n" + changed + "\n// component options: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// component options: START");
            this.getLog().warn((CharSequence)"\t// component options: END");
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateEndpointOptions(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// endpoint options: START", "// endpoint options: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// endpoint options: START");
                String after = StringHelper.after(text, "// endpoint options: END");
                text = before + "// endpoint options: START\n" + changed + "\n// endpoint options: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// endpoint options: START");
            this.getLog().warn((CharSequence)"\t// endpoint options: END");
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateDataFormatOptions(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// dataformat options: START", "// dataformat options: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// dataformat options: START");
                String after = StringHelper.after(text, "// dataformat options: END");
                text = before + "// dataformat options: START\n" + changed + "\n// dataformat options: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// dataformat options: START");
            this.getLog().warn((CharSequence)"\t// dataformat options: END");
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateLanguageOptions(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// language options: START", "// language options: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// language options: START");
                String after = StringHelper.after(text, "// language options: END");
                text = before + "// language options: START\n" + changed + "\n// language options: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// language options: START");
            this.getLog().warn((CharSequence)"\t// language options: END");
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateEipOptions(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, "// eip options: START", "// eip options: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, "// eip options: START");
                String after = StringHelper.after(text, "// eip options: END");
                text = before + "// eip options: START\n" + changed + "\n// eip options: END" + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// eip options: START");
            this.getLog().warn((CharSequence)"\t// eip options: END");
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private String loadComponentJson(Set<File> jsonFiles, String componentName) {
        try {
            for (File file : jsonFiles) {
                String json;
                boolean isComponent;
                if (!file.getName().equals(componentName + ".json") || !(isComponent = (json = PackageHelper.loadText(new FileInputStream(file))).contains("\"kind\": \"component\""))) continue;
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String loadDataFormatJson(Set<File> jsonFiles, String dataFormatName) {
        try {
            for (File file : jsonFiles) {
                String json;
                boolean isDataFormat;
                if (!file.getName().equals(dataFormatName + ".json") || !(isDataFormat = (json = PackageHelper.loadText(new FileInputStream(file))).contains("\"kind\": \"dataformat\""))) continue;
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String loadLanguageJson(Set<File> jsonFiles, String languageName) {
        try {
            for (File file : jsonFiles) {
                String json;
                boolean isLanguage;
                if (!file.getName().equals(languageName + ".json") || !(isLanguage = (json = PackageHelper.loadText(new FileInputStream(file))).contains("\"kind\": \"language\""))) continue;
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String loadEipJson(File file) {
        try {
            String json = PackageHelper.loadText(new FileInputStream(file));
            boolean isEip = json.contains("\"kind\": \"model\"");
            if (isEip) {
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private ComponentModel generateComponentModel(String componentName, String json) {
        String desc;
        Object option;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        ComponentModel component = new ComponentModel(true);
        component.setScheme(JSonSchemaHelper.getSafeValue("scheme", rows));
        component.setSyntax(JSonSchemaHelper.getSafeValue("syntax", rows));
        component.setAlternativeSyntax(JSonSchemaHelper.getSafeValue("alternativeSyntax", rows));
        component.setAlternativeSchemes(JSonSchemaHelper.getSafeValue("alternativeSchemes", rows));
        component.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        component.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        component.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        component.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        component.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        component.setConsumerOnly(JSonSchemaHelper.getSafeValue("consumerOnly", rows));
        component.setProducerOnly(JSonSchemaHelper.getSafeValue("producerOnly", rows));
        component.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        component.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        component.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        component.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        String oldGroup = null;
        rows = JSonSchemaHelper.parseJsonSchema("componentProperties", json, true);
        for (Map<String, String> row : rows) {
            option = new ComponentOptionModel();
            ((ComponentOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((ComponentOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((ComponentOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((ComponentOptionModel)option).setGroup(JSonSchemaHelper.getSafeValue("group", row));
            ((ComponentOptionModel)option).setRequired(JSonSchemaHelper.getSafeValue("required", row));
            ((ComponentOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((ComponentOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((ComponentOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            ((ComponentOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((ComponentOptionModel)option).setSecret(JSonSchemaHelper.getSafeValue("secret", row));
            ((ComponentOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((ComponentOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            if ("true".equals(((ComponentOptionModel)option).getRequired())) {
                desc = "*Required* " + ((ComponentOptionModel)option).getDescription();
                ((ComponentOptionModel)option).setDescription(desc);
            }
            component.addComponentOption((ComponentOptionModel)option);
            if (oldGroup == null || !oldGroup.equals(((ComponentOptionModel)option).getGroup())) {
                ((ComponentOptionModel)option).setNewGroup(true);
            }
            oldGroup = ((ComponentOptionModel)option).getGroup();
        }
        oldGroup = null;
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            option = new EndpointOptionModel();
            ((EndpointOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((EndpointOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((EndpointOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((EndpointOptionModel)option).setGroup(JSonSchemaHelper.getSafeValue("group", row));
            ((EndpointOptionModel)option).setRequired(JSonSchemaHelper.getSafeValue("required", row));
            ((EndpointOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((EndpointOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((EndpointOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            ((EndpointOptionModel)option).setPrefix(JSonSchemaHelper.getSafeValue("prefix", row));
            ((EndpointOptionModel)option).setMultiValue(JSonSchemaHelper.getSafeValue("multiValue", row));
            ((EndpointOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((EndpointOptionModel)option).setSecret(JSonSchemaHelper.getSafeValue("secret", row));
            ((EndpointOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((EndpointOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            if ("true".equals(((EndpointOptionModel)option).getRequired())) {
                desc = "*Required* " + ((EndpointOptionModel)option).getDescription();
                ((EndpointOptionModel)option).setDescription(desc);
            }
            if ("path".equals(((EndpointOptionModel)option).getKind())) {
                component.addEndpointPathOption((EndpointOptionModel)option);
            } else {
                component.addEndpointOption((EndpointOptionModel)option);
            }
            if (oldGroup == null || !oldGroup.equals(((EndpointOptionModel)option).getGroup())) {
                ((EndpointOptionModel)option).setNewGroup(true);
            }
            oldGroup = ((EndpointOptionModel)option).getGroup();
        }
        return component;
    }

    private DataFormatModel generateDataFormatModel(String dataFormatName, String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
        DataFormatModel dataFormat = new DataFormatModel();
        dataFormat.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        dataFormat.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        dataFormat.setName(JSonSchemaHelper.getSafeValue("name", rows));
        dataFormat.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        dataFormat.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        dataFormat.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        dataFormat.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        dataFormat.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        dataFormat.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        dataFormat.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        dataFormat.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            DataFormatOptionModel option = new DataFormatOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            if (dataFormatName.startsWith("bindy") && option.getName().equals("type")) {
                option.setDefaultValue("");
                String doc = option.getDescription() + " The default value is either Csv or KeyValue depending on chosen dataformat.";
                option.setDescription(doc);
            }
            if ("id".equals(option.getName())) {
                this.getLog().debug((CharSequence)("Skipping option: " + option.getName()));
                continue;
            }
            dataFormat.addDataFormatOption(option);
        }
        return dataFormat;
    }

    private LanguageModel generateLanguageModel(String languageName, String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
        LanguageModel language = new LanguageModel();
        language.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        language.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        language.setName(JSonSchemaHelper.getSafeValue("name", rows));
        language.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        language.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        language.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        language.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        language.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        language.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        language.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        language.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            LanguageOptionModel option = new LanguageOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            if ("id".equals(option.getName()) || "expression".equals(option.getName())) {
                this.getLog().debug((CharSequence)("Skipping option: " + option.getName()));
                continue;
            }
            language.addLanguageOption(option);
        }
        return language;
    }

    private EipModel generateEipModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
        EipModel eip = new EipModel();
        eip.setName(JSonSchemaHelper.getSafeValue("name", rows));
        eip.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        eip.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        eip.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        eip.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        eip.setDeprecated("true".equals(JSonSchemaHelper.getSafeValue("deprecated", rows)));
        eip.setInput("true".equals(JSonSchemaHelper.getSafeValue("input", rows)));
        eip.setOutput("true".equals(JSonSchemaHelper.getSafeValue("output", rows)));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            EipOptionModel option = new EipOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setRequired(JSonSchemaHelper.getSafeValue("required", row));
            option.setDeprecated("true".equals(JSonSchemaHelper.getSafeValue("deprecated", row)));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            option.setInput("true".equals(JSonSchemaHelper.getSafeValue("input", row)));
            option.setOutput("true".equals(JSonSchemaHelper.getSafeValue("output", row)));
            if ("true".equals(option.getRequired())) {
                String desc = "*Required* " + option.getDescription();
                option.setDescription(desc);
            }
            if ("id".equals(option.getName()) || "description".equals(option.getName()) || "expression".equals(option.getName()) || "outputs".equals(option.getName())) {
                this.getLog().debug((CharSequence)("Skipping option: " + option.getName()));
                continue;
            }
            eip.addEipOptionModel(option);
        }
        return eip;
    }

    private String templateComponentHeader(ComponentModel model) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("component-header.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, (Object)model);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateComponentOptions(ComponentModel model) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("component-options.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, (Object)model);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateEndpointOptions(ComponentModel model) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("endpoint-options.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, (Object)model);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateDataFormatOptions(DataFormatModel model) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("dataformat-options.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, (Object)model);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateLanguageOptions(LanguageModel model) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("language-options.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, (Object)model);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateEipOptions(EipModel model) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText(UpdateReadmeMojo.class.getClassLoader().getResourceAsStream("eip-options.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, (Object)model);
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private List<String> findComponentNames() {
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Resource r : this.project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(this.project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/component")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                componentNames.add(name);
            }
        }
        return componentNames;
    }

    private List<String> findDataFormatNames() {
        ArrayList<String> dataFormatNames = new ArrayList<String>();
        for (Resource r : this.project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(this.project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/dataformat")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                dataFormatNames.add(name);
            }
        }
        return dataFormatNames;
    }

    private List<String> findLanguageNames() {
        ArrayList<String> languageNames = new ArrayList<String>();
        for (Resource r : this.project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(this.project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/language")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                languageNames.add(name);
            }
        }
        return languageNames;
    }

    private boolean isFailFast() {
        return this.failFast != null && this.failFast != false;
    }
}

