/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.SpringBootHelper;
import org.apache.camel.maven.packaging.model.ComponentModel;
import org.apache.camel.maven.packaging.model.ComponentOptionModel;
import org.apache.camel.maven.packaging.model.DataFormatModel;
import org.apache.camel.maven.packaging.model.DataFormatOptionModel;
import org.apache.camel.maven.packaging.model.EndpointOptionModel;
import org.apache.camel.maven.packaging.model.LanguageModel;
import org.apache.camel.maven.packaging.model.LanguageOptionModel;
import org.apache.camel.maven.packaging.model.OtherModel;
import org.apache.camel.maven.packaging.model.OtherOptionModel;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.PropertySource;
import org.jboss.forge.roaster.model.util.Formatter;
import org.jboss.forge.roaster.model.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class SpringBootAutoConfigurationMojo
extends AbstractMojo {
    private static final boolean DELETE_FILES_ON_MAIN_ARTIFACTS = false;
    private static final String INNER_TYPE_SUFFIX = "NestedConfiguration";
    private static final Pattern EXCLUDE_INNER_PATTERN = Pattern.compile("^((java\\.)|(javax\\.)|(org\\.springframework\\.context\\.ApplicationContext)|(freemarker\\.template\\.Configuration)).*");
    private static final Map<String, String> PRIMITIVEMAP = new HashMap<String, String>();
    private static final List<String> JAVA_LANG_TYPES;
    private static final String[] IGNORE_MODULES;
    protected File classesDir;
    protected MavenProject project;
    protected File buildDir;
    protected File baseDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Arrays.asList(IGNORE_MODULES).contains(this.project.getArtifactId())) {
            this.getLog().info((CharSequence)"Component auto-configuration will not be created: component contained in the ignore list");
            return;
        }
        File starterDir = SpringBootHelper.starterDir(this.baseDir, this.project.getArtifactId());
        if (!starterDir.exists() || !new File(starterDir, "pom.xml").exists()) {
            this.getLog().info((CharSequence)"Component auto-configuration will not be created: the starter does not exist");
            return;
        }
        this.executeModels();
        this.executeComponent();
        this.executeDataFormat();
        this.executeLanguage();
    }

    private void executeModels() throws MojoExecutionException, MojoFailureException {
        String pkg;
        int pos;
        OtherModel model;
        Set<File> files = PackageHelper.findJsonFiles(this.buildDir, p -> p.isDirectory() || p.getName().endsWith(".json"));
        String json = SpringBootAutoConfigurationMojo.loadModelJson(files, "hystrixConfiguration");
        if (json != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.hystrix", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "consulServiceDiscovery")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.consul.service-discovery", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "dnsServiceDiscovery")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.dns.service-discovery", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "etcdServiceDiscovery")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.etcd.service-discovery", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "kubernetesServiceDiscovery")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.kubernetes.service-discovery", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "ribbonLoadBalancer")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.ribbon.load-balancer", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "restConfiguration")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createRestConfigurationSource(pkg, model, "camel.rest");
            this.createRestModuleAutoConfigurationSource(pkg, model);
        }
    }

    private void createOtherModelConfigurationSource(String packageName, OtherModel model, String propertiesPrefix, boolean generatedNestedConfig) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String commonName = model.getJavaType().substring(pos + 1) + (generatedNestedConfig ? "Common" : "Properties");
        String configName = model.getJavaType().substring(pos + 1) + (generatedNestedConfig ? "Properties" : null);
        JavaClassSource commonClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        commonClass.setPackage(packageName);
        commonClass.setName(commonName);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        commonClass.getJavaDoc().setFullText(doc);
        commonClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        for (OtherOptionModel option : model.getOptions()) {
            String type = option.getJavaType();
            String name = option.getName();
            if ("id".equalsIgnoreCase(name) || "parent".equalsIgnoreCase(name) || "camelContext".equalsIgnoreCase(name)) continue;
            if ("java.util.List<org.apache.camel.model.PropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.String>";
            }
            PropertySource prop = commonClass.addProperty(type, option.getName());
            if (!Strings.isBlank((String)option.getDescription())) {
                prop.getField().getJavaDoc().setFullText(option.getDescription());
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(type)) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(type) || "java.lang.Long".equals(type)) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            commonClass.addImport(model.getJavaType());
        }
        SpringBootAutoConfigurationMojo.sortImports(commonClass);
        this.writeSourceIfChanged(commonClass, packageName.replaceAll("\\.", "\\/") + "/" + commonName + ".java");
        if (generatedNestedConfig) {
            JavaClassSource configClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
            configClass.setPackage(packageName);
            configClass.setName(configName);
            configClass.extendSuperType((JavaClass)commonClass);
            configClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
            configClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", propertiesPrefix);
            configClass.addImport(Map.class);
            configClass.addImport(HashMap.class);
            configClass.removeImport((JavaType)commonClass);
            ((FieldSource)((FieldSource)configClass.addField().setName("enabled")).setType(Boolean.TYPE).setPrivate()).setLiteralInitializer("true").getJavaDoc().setFullText("Enable the component");
            ((FieldSource)configClass.addField("Map<String, " + commonName + "> configurations = new HashMap<>()").setPrivate()).getJavaDoc().setFullText("Define additional configuration definitions");
            MethodSource method = configClass.addMethod();
            method.setName("getConfigurations");
            method.setReturnType("Map<String, " + commonName + ">");
            method.setPublic();
            method.setBody("return configurations;");
            method = configClass.addMethod();
            method.setName("isEnabled");
            method.setReturnType(Boolean.TYPE);
            method.setPublic();
            method.setBody("return enabled;");
            method = configClass.addMethod();
            method.setName("setEnabled");
            method.addParameter(Boolean.TYPE, "enabled");
            method.setPublic();
            method.setBody("this.enabled = enabled;");
            SpringBootAutoConfigurationMojo.sortImports(configClass);
            this.writeSourceIfChanged(configClass, packageName.replaceAll("\\.", "\\/") + "/" + configName + ".java");
        }
    }

    private void createRestConfigurationSource(String packageName, OtherModel model, String propertiesPrefix) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String className = model.getJavaType().substring(pos + 1) + "Properties";
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        javaClass.setPackage(packageName);
        javaClass.setName(className);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", propertiesPrefix);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        for (OtherOptionModel option : model.getOptions()) {
            String type = option.getJavaType();
            String name = option.getName();
            if ("id".equalsIgnoreCase(name) || "parent".equalsIgnoreCase(name) || "camelContext".equalsIgnoreCase(name)) continue;
            if ("java.util.List<org.apache.camel.model.PropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.String>";
            } else if ("java.util.List<org.apache.camel.model.rest.RestPropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.Object>";
            }
            if ("enableCORS".equalsIgnoreCase(name)) {
                name = "enableCors";
            }
            PropertySource prop = javaClass.addProperty(type, name);
            if (!Strings.isBlank((String)option.getDescription())) {
                prop.getField().getJavaDoc().setFullText(option.getDescription());
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(type)) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(type) || "java.lang.Long".equals(type)) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        this.writeSourceIfChanged(javaClass, packageName.replaceAll("\\.", "\\/") + "/" + className + ".java");
    }

    private void createRestModuleAutoConfigurationSource(String packageName, OtherModel model) throws MojoFailureException {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1) + "AutoConfiguration";
        String configType = model.getJavaType().substring(pos + 1) + "Properties";
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        javaClass.getJavaDoc().setFullText(doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(ConditionalOnBean.class).setStringValue("type", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(ConditionalOnProperty.class).setStringValue("name", "camel.rest.enabled").setLiteralValue("matchIfMissing", "true");
        javaClass.addAnnotation(AutoConfigureAfter.class).setStringValue("name", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("value", configType + ".class");
        javaClass.addImport("java.util.Map");
        javaClass.addImport("java.util.HashMap");
        javaClass.addImport("org.apache.camel.util.CollectionHelper");
        javaClass.addImport("org.apache.camel.util.IntrospectionSupport");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.model.rest.RestConstants");
        javaClass.addImport("org.apache.camel.spi.RestConfiguration");
        ((FieldSource)((FieldSource)javaClass.addField().setName("camelContext")).setType("org.apache.camel.CamelContext").setPrivate()).addAnnotation(Autowired.class);
        ((FieldSource)((FieldSource)javaClass.addField().setName("config")).setType(configType).setPrivate()).addAnnotation(Autowired.class);
        MethodSource method = javaClass.addMethod();
        method.setName("configure" + model.getShortJavaType());
        method.setPublic();
        method.addThrows(Exception.class);
        method.setReturnType("org.apache.camel.spi.RestConfiguration");
        method.addAnnotation(Lazy.class);
        method.addAnnotation(Bean.class).setLiteralValue("name", "RestConstants.DEFAULT_REST_CONFIGURATION_ID");
        method.addAnnotation(ConditionalOnClass.class).setLiteralValue("value", "CamelContext.class");
        method.addAnnotation(ConditionalOnMissingBean.class);
        method.setBody("Map<String, Object> properties = new HashMap<>();\nIntrospectionSupport.getProperties(config, properties, null, false);\n\nRestConfiguration definition = new RestConfiguration();\nIntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), definition, properties);\n\n// Workaround for spring-boot properties name as It would appear\n// as enable-c-o-r-s if left uppercase in Configuration\ndefinition.setEnableCORS(config.getEnableCors());\n\nif (config.getApiProperty() != null) {\n    definition.setApiProperties(new HashMap<>(CollectionHelper.flatternKeysInMap(config.getApiProperty(), \".\")));\n}\nif (config.getComponentProperty() != null) {\n    definition.setComponentProperties(new HashMap<>(CollectionHelper.flatternKeysInMap(config.getComponentProperty(), \".\")));\n}\nif (config.getConsumerProperty() != null) {\n    definition.setConsumerProperties(new HashMap<>(CollectionHelper.flatternKeysInMap(config.getConsumerProperty(), \".\")));\n}\nif (config.getDataFormatProperty() != null) {\n    definition.setDataFormatProperties(new HashMap<>(CollectionHelper.flatternKeysInMap(config.getDataFormatProperty(), \".\")));\n}\nif (config.getEndpointProperty() != null) {\n    definition.setEndpointProperties(new HashMap<>(CollectionHelper.flatternKeysInMap(config.getEndpointProperty(), \".\")));\n}\nif (config.getCorsHeaders() != null) {\n    Map<String, Object> map = CollectionHelper.flatternKeysInMap(config.getCorsHeaders(), \".\");\n    Map<String, String> target = new HashMap<>();\n    map.forEach((k, v) -> target.put(k, v.toString()));\n    definition.setCorsHeaders(target);\n}\nreturn definition;");
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName);
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void executeComponent() throws MojoExecutionException, MojoFailureException {
        List<String> componentNames = this.findComponentNames();
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            LinkedList<ComponentModel> allModels = new LinkedList<ComponentModel>();
            for (String componentName : componentNames) {
                String json = SpringBootAutoConfigurationMojo.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                ComponentModel model = SpringBootAutoConfigurationMojo.generateComponentModel(componentName, json);
                allModels.add(model);
            }
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(ComponentModel::getJavaType));
            for (String componentClass : grModels.keySet()) {
                List<ComponentModel> compModels = grModels.get(componentClass);
                ComponentModel model = compModels.get(0);
                List<String> aliases = compModels.stream().map(ComponentModel::getScheme).sorted().collect(Collectors.toList());
                boolean hasOptions = model.getComponentOptions().stream().anyMatch(o -> !o.getName().equals("resolvePropertyPlaceholders"));
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideComponentName = null;
                if (aliases.size() > 1) {
                    overrideComponentName = model.getArtifactId().replace("camel-", "");
                }
                if (hasOptions) {
                    this.createComponentConfigurationSource(pkg, model, overrideComponentName);
                }
                this.createComponentAutoConfigurationSource(pkg, model, aliases, hasOptions, overrideComponentName);
                this.createComponentSpringFactorySource(pkg, model);
            }
        }
    }

    private void executeDataFormat() throws MojoExecutionException, MojoFailureException {
        List<String> dataFormatNames = this.findDataFormatNames();
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!dataFormatNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + dataFormatNames.size() + " dataformats"));
            LinkedList<DataFormatModel> allModels = new LinkedList<DataFormatModel>();
            for (String dataFormatName : dataFormatNames) {
                String json = SpringBootAutoConfigurationMojo.loadDataFormatJson(jsonFiles, dataFormatName);
                if (json == null) continue;
                DataFormatModel model = SpringBootAutoConfigurationMojo.generateDataFormatModel(dataFormatName, json);
                allModels.add(model);
            }
            Map<String, List<DataFormatModel>> grModels = allModels.stream().collect(Collectors.groupingBy(DataFormatModel::getJavaType));
            for (String dataFormatClass : grModels.keySet()) {
                List<DataFormatModel> dfModels = grModels.get(dataFormatClass);
                DataFormatModel model = dfModels.get(0);
                List<String> aliases = dfModels.stream().map(DataFormatModel::getName).sorted().collect(Collectors.toList());
                boolean hasOptions = !model.getDataFormatOptions().isEmpty();
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideDataFormatName = null;
                if (aliases.size() > 1) {
                    overrideDataFormatName = model.getArtifactId().replace("camel-", "");
                }
                if (hasOptions) {
                    this.createDataFormatConfigurationSource(pkg, model, overrideDataFormatName);
                }
                this.createDataFormatAutoConfigurationSource(pkg, model, aliases, hasOptions, overrideDataFormatName);
                this.createDataFormatSpringFactorySource(pkg, model);
            }
        }
    }

    private void executeLanguage() throws MojoExecutionException, MojoFailureException {
        List<String> languageNames = this.findLanguageNames();
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!languageNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + languageNames.size() + " languages"));
            LinkedList<LanguageModel> allModels = new LinkedList<LanguageModel>();
            for (String languageName : languageNames) {
                String json = SpringBootAutoConfigurationMojo.loadLanguageJson(jsonFiles, languageName);
                if (json == null) continue;
                LanguageModel model = SpringBootAutoConfigurationMojo.generateLanguageModel(languageName, json);
                allModels.add(model);
            }
            Map<String, List<LanguageModel>> grModels = allModels.stream().collect(Collectors.groupingBy(LanguageModel::getJavaType));
            for (String languageClass : grModels.keySet()) {
                List<LanguageModel> dfModels = grModels.get(languageClass);
                LanguageModel model = dfModels.get(0);
                List<String> aliases = dfModels.stream().map(LanguageModel::getName).sorted().collect(Collectors.toList());
                boolean hasOptions = !model.getLanguageOptions().isEmpty();
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideLanguageName = null;
                if (aliases.size() > 1) {
                    overrideLanguageName = model.getArtifactId().replace("camel-", "");
                }
                if (hasOptions) {
                    this.createLanguageConfigurationSource(pkg, model, overrideLanguageName);
                }
                this.createLanguageAutoConfigurationSource(pkg, model, aliases, hasOptions, overrideLanguageName);
                this.createLanguageSpringFactorySource(pkg, model);
            }
        }
    }

    private void createComponentConfigurationSource(String packageName, ComponentModel model, String overrideComponentName) throws MojoFailureException {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Component", "ComponentConfiguration");
        ((JavaClassSource)javaClass.setPackage(packageName)).setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        String prefix = "camel.component." + (overrideComponentName != null ? overrideComponentName : model.getScheme());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        HashSet<JavaClassSource> nestedTypes = new HashSet<JavaClassSource>();
        for (ComponentOptionModel componentOptionModel : model.getComponentOptions()) {
            if (SpringBootAutoConfigurationMojo.skipComponentOption(model, componentOptionModel)) continue;
            String type = componentOptionModel.getJavaType();
            JavaClassSource javaClassSource = this.readJavaType(type = this.getSimpleJavaType(type));
            if (this.isNestedProperty(nestedTypes, javaClassSource)) {
                type = componentOptionModel.getShortJavaType() + INNER_TYPE_SUFFIX;
            }
            PropertySource prop = javaClass.addProperty(type, componentOptionModel.getName());
            if (!type.endsWith(INNER_TYPE_SUFFIX) && type.indexOf(91) == -1 && !EXCLUDE_INNER_PATTERN.matcher(type).matches() && Strings.isBlank((String)componentOptionModel.getEnums()) && (javaClassSource == null || javaClassSource.isClass() && !javaClassSource.isAbstract())) {
                prop.getField().addAnnotation(NestedConfigurationProperty.class);
            }
            if ("true".equals(componentOptionModel.getDeprecated())) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isBlank((String)componentOptionModel.getDescription())) {
                prop.getField().getJavaDoc().setFullText(componentOptionModel.getDescription());
            }
            if (Strings.isBlank((String)componentOptionModel.getDefaultValue())) continue;
            if ("java.lang.String".equals(componentOptionModel.getJavaType())) {
                prop.getField().setStringInitializer(componentOptionModel.getDefaultValue());
                continue;
            }
            if ("long".equals(componentOptionModel.getJavaType()) || "java.lang.Long".equals(componentOptionModel.getJavaType())) {
                String value = componentOptionModel.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(componentOptionModel.getType()) || "boolean".equals(componentOptionModel.getType())) {
                prop.getField().setLiteralInitializer(componentOptionModel.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)componentOptionModel.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + componentOptionModel.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        ClassLoader projectClassLoader = this.getProjectClassLoader();
        for (JavaClassSource nestedType : nestedTypes) {
            JavaClassSource innerClass = (JavaClassSource)javaClass.addNestedType("public static class " + nestedType.getName() + INNER_TYPE_SUFFIX);
            ((FieldSource)((FieldSource)((FieldSource)((FieldSource)innerClass.addField().setPublic()).setStatic(true)).setFinal(true)).setType(Class.class).setName("CAMEL_NESTED_CLASS")).setLiteralInitializer(nestedType.getCanonicalName() + ".class");
            for (ResolvedProperty resolvedProperty : this.getProperties(nestedType)) {
                boolean anEnum;
                Class optionClass;
                String optionType = resolvedProperty.propertyType;
                PropertySource sourceProp = resolvedProperty.propertySource;
                Type propType = sourceProp.getType();
                PropertySource prop = innerClass.addProperty(optionType, sourceProp.getName());
                if (!propType.isArray()) {
                    optionClass = this.loadClass(projectClassLoader, optionType);
                    anEnum = optionClass.isEnum();
                } else {
                    optionClass = null;
                    anEnum = false;
                }
                if (!(EXCLUDE_INNER_PATTERN.matcher(optionType).matches() || propType.isArray() || anEnum || optionClass == null || optionClass.isInterface() || optionClass.isAnnotation() || Modifier.isAbstract(optionClass.getModifiers()))) {
                    prop.getField().addAnnotation(NestedConfigurationProperty.class);
                }
                if (sourceProp.hasAnnotation(Deprecated.class)) {
                    prop.getField().addAnnotation(Deprecated.class);
                    prop.getAccessor().addAnnotation(Deprecated.class);
                    prop.getMutator().addAnnotation(Deprecated.class);
                    prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
                }
                String description = null;
                MethodSource mutator = sourceProp.getMutator();
                if (mutator.hasJavaDoc()) {
                    description = mutator.getJavaDoc().getFullText();
                } else if (sourceProp.hasField()) {
                    description = sourceProp.getField().getJavaDoc().getFullText();
                }
                if (!Strings.isBlank((String)description)) {
                    prop.getField().getJavaDoc().setFullText(description);
                }
                if (!sourceProp.hasAnnotation(UriParam.class) && !sourceProp.hasAnnotation(UriPath.class)) continue;
                String defaultValue = null;
                String javaType = null;
                String type = null;
                String fileName = model.getJavaType();
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
                File jsonFile = new File(this.classesDir, (fileName = fileName.replace('.', '/')) + "/" + model.getScheme() + ".json");
                if (jsonFile.isFile() && jsonFile.exists()) {
                    try {
                        String json = FileUtils.readFileToString((File)jsonFile);
                        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
                        String optionName = sourceProp.hasAnnotation(UriParam.class) ? sourceProp.getAnnotation(UriParam.class).getStringValue("name") : sourceProp.getAnnotation(UriPath.class).getStringValue("name");
                        if (optionName == null) {
                            String string = optionName = sourceProp.hasField() ? sourceProp.getField().getName() : null;
                        }
                        if (optionName != null) {
                            javaType = JSonSchemaHelper.getPropertyJavaType(rows, optionName);
                            type = JSonSchemaHelper.getPropertyType(rows, optionName);
                            defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, optionName);
                        }
                    }
                    catch (IOException json) {
                        // empty catch block
                    }
                }
                if (Strings.isBlank(defaultValue)) continue;
                String wrapperType = this.getSimpleJavaType(javaType);
                if (wrapperType.startsWith("java.lang.")) {
                    wrapperType = wrapperType.substring(10);
                    prop.setType(wrapperType);
                }
                if ("long".equals(javaType) || "java.lang.Long".equals(javaType)) {
                    String value = defaultValue + "L";
                    prop.getField().setLiteralInitializer(value);
                    continue;
                }
                if ("integer".equals(type) || "boolean".equals(type)) {
                    prop.getField().setLiteralInitializer(defaultValue);
                    continue;
                }
                if ("string".equals(type)) {
                    prop.getField().setStringInitializer(defaultValue);
                    continue;
                }
                if (!anEnum) continue;
                String enumShortName = optionClass.getSimpleName();
                prop.getField().setLiteralInitializer(enumShortName + "." + defaultValue);
                javaClass.addImport(model.getJavaType());
            }
        }
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String string = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, string);
    }

    private List<ResolvedProperty> getProperties(JavaClassSource nestedType) {
        ArrayList<ResolvedProperty> properties = new ArrayList<ResolvedProperty>();
        HashSet<String> names = new HashSet<String>();
        do {
            for (PropertySource propertySource : nestedType.getProperties()) {
                if (!propertySource.isMutable() || names.contains(propertySource.getName())) continue;
                properties.add(new ResolvedProperty(this.getSimpleJavaType(this.resolveParamType(nestedType, propertySource.getType().getName())), (PropertySource<JavaClassSource>)propertySource));
                names.add(propertySource.getName());
            }
        } while ((nestedType = this.readJavaType(nestedType.getSuperType())) != null);
        return properties;
    }

    private Class loadClass(ClassLoader projectClassLoader, String loadClassName) throws MojoFailureException {
        Class<?> optionClass;
        while (true) {
            try {
                optionClass = projectClassLoader.loadClass(loadClassName);
            }
            catch (ClassNotFoundException e) {
                int dotIndex = loadClassName.lastIndexOf(46);
                if (dotIndex == -1) {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                }
                loadClassName = loadClassName.substring(0, dotIndex) + "$" + loadClassName.substring(dotIndex + 1);
                continue;
            }
            break;
        }
        return optionClass;
    }

    private String resolveParamType(JavaClassSource nestedType, String type) {
        int innerStart = type.indexOf(46);
        int arrayStart = type.indexOf(91);
        String result = innerStart != -1 ? nestedType.resolveType(type.substring(0, innerStart)) + type.substring(innerStart) : nestedType.resolveType(type);
        return arrayStart == -1 ? result : result + type.substring(arrayStart);
    }

    protected ClassLoader getProjectClassLoader() throws MojoFailureException {
        List classpathElements;
        try {
            classpathElements = this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        URL[] urls = new URL[classpathElements.size()];
        int i = 0;
        Iterator it = classpathElements.iterator();
        while (it.hasNext()) {
            try {
                urls[i] = new File((String)it.next()).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return new URLClassLoader(urls, tccl != null ? tccl : ((Object)((Object)this)).getClass().getClassLoader());
    }

    private String getSimpleJavaType(String type) {
        String wrapper = PRIMITIVEMAP.get(type = type.replaceAll("\\<\\?\\>", ""));
        if (wrapper != null) {
            type = wrapper;
        }
        return type;
    }

    private boolean isNestedProperty(Set<JavaClassSource> nestedTypes, JavaClassSource type) {
        if (type != null) {
            if (type.isClass() && !type.isEnum() && !type.isAbstract() && !type.getProperties().isEmpty()) {
                nestedTypes.add(type);
            } else {
                type = null;
            }
        }
        return type != null;
    }

    private JavaClassSource readJavaType(String type) {
        JavaClassSource nestedType = null;
        if (!type.startsWith("java.lang.")) {
            String fileName = type.replaceAll("[\\[\\]]", "").replaceAll("\\.", "\\/") + ".java";
            for (Object sourceRoot : this.project.getCompileSourceRoots()) {
                File sourceFile = new File(sourceRoot.toString(), fileName);
                if (!sourceFile.isFile()) continue;
                try {
                    JavaType classSource = Roaster.parse((File)sourceFile);
                    if (!(classSource instanceof JavaClassSource)) continue;
                    nestedType = (JavaClassSource)classSource;
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException("Missing source file " + type);
                }
            }
        }
        return nestedType;
    }

    private static boolean skipComponentOption(ComponentModel model, ComponentOptionModel option) {
        String name;
        return !(!"netty4-http".equals(model.getScheme()) && !"netty-http".equals(model.getScheme()) || !(name = option.getName()).equals("textline") && !name.equals("delimiter") && !name.equals("autoAppendDelimiter") && !name.equals("decoderMaxLineLength") && !name.equals("encoding") && !name.equals("allowDefaultCodec") && !name.equals("udpConnectionlessSending") && !name.equals("networkInterface") && !name.equals("clientMode") && !name.equals("reconnect") && !name.equals("reconnectInterval") && !name.equals("useByteBuf") && !name.equals("udpByteArrayCodec") && !name.equals("broadcast"));
    }

    private void createDataFormatConfigurationSource(String packageName, DataFormatModel model, String overrideDataFormatName) throws MojoFailureException {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("DataFormat", "DataFormatConfiguration");
        ((JavaClassSource)javaClass.setPackage(packageName)).setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        String prefix = "camel.dataformat." + (overrideDataFormatName != null ? overrideDataFormatName : model.getName());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        for (DataFormatOptionModel option : model.getDataFormatOptions()) {
            if ("id".equals(option.getName())) continue;
            String type = option.getJavaType();
            type = this.getSimpleJavaType(type);
            PropertySource prop = javaClass.addProperty(type, option.getName());
            if ("true".equals(option.getDeprecated())) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isBlank((String)option.getDescription())) {
                prop.getField().getJavaDoc().setFullText(option.getDescription());
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(option.getType())) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnumValues())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName);
    }

    private void createLanguageConfigurationSource(String packageName, LanguageModel model, String overrideLanguageName) throws MojoFailureException {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Language", "LanguageConfiguration");
        ((JavaClassSource)javaClass.setPackage(packageName)).setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        String prefix = "camel.language." + (overrideLanguageName != null ? overrideLanguageName : model.getName());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        for (LanguageOptionModel option : model.getLanguageOptions()) {
            if ("id".equals(option.getName()) || "expression".equals(option.getName()) || "resultType".equals(option.getName()) || ("bean".equals(model.getName()) ? "bean".equals(option.getName()) || "ref".equals(option.getName()) || "method".equals(option.getName()) || "beanType".equals(option.getName()) : ("tokenize".equals(model.getName()) ? "token".equals(option.getName()) || "endToken".equals(option.getName()) || "inheritNamespaceTagName".equals(option.getName()) || "headerName".equals(option.getName()) || "regex".equals(option.getName()) || "xml".equals(option.getName()) || "includeTokens".equals(option.getName()) || "group".equals(option.getName()) || "skipFirst".equals(option.getName()) : ("xtokenize".equals(model.getName()) ? "headerName".equals(option.getName()) || "group".equals(option.getName()) : ("xpath".equals(model.getName()) ? "headerName".equals(option.getName()) : "xquery".equals(model.getName()) && "headerName".equals(option.getName())))))) continue;
            String type = option.getJavaType();
            type = this.getSimpleJavaType(type);
            PropertySource prop = javaClass.addProperty(type, option.getName());
            if ("true".equals(option.getDeprecated())) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isBlank((String)option.getDescription())) {
                prop.getField().getJavaDoc().setFullText(option.getDescription());
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(option.getType())) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnumValues())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName);
    }

    private void createComponentAutoConfigurationSource(String packageName, ComponentModel model, List<String> componentAliases, boolean hasOptions, String overrideComponentName) throws MojoFailureException {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Component", "ComponentAutoConfiguration");
        ((JavaClassSource)javaClass.setPackage(packageName)).setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        javaClass.getJavaDoc().setFullText(doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(ConditionalOnBean.class).setStringValue("type", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(Conditional.class).setLiteralValue(name + ".Condition.class");
        javaClass.addAnnotation(AutoConfigureAfter.class).setStringValue("name", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        String configurationName = name.replace("ComponentAutoConfiguration", "ComponentConfiguration");
        if (hasOptions) {
            AnnotationSource ann = javaClass.addAnnotation(EnableConfigurationProperties.class);
            ann.setLiteralValue("value", configurationName + ".class");
            javaClass.addImport("java.util.HashMap");
            javaClass.addImport("java.util.Map");
            javaClass.addImport("org.apache.camel.util.IntrospectionSupport");
        }
        javaClass.addImport(model.getJavaType());
        javaClass.addImport("org.apache.camel.CamelContext");
        String body = SpringBootAutoConfigurationMojo.createComponentBody(model.getShortJavaType(), hasOptions);
        String methodName = "configure" + model.getShortJavaType();
        MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(methodName)).setPublic()).setBody(body).setReturnType(model.getShortJavaType()).addThrows(Exception.class);
        method.addParameter("CamelContext", "camelContext");
        if (hasOptions) {
            method.addParameter(configurationName, "configuration");
        }
        String[] springBeanAliases = (String[])componentAliases.stream().map(alias -> alias + "-component").toArray(String[]::new);
        method.addAnnotation(Lazy.class);
        method.addAnnotation(Bean.class).setStringArrayValue("name", springBeanAliases);
        method.addAnnotation(ConditionalOnClass.class).setLiteralValue("value", "CamelContext.class");
        method.addAnnotation(ConditionalOnMissingBean.class).setLiteralValue("value", model.getShortJavaType() + ".class");
        javaClass.addNestedType((JavaSource)this.createConditionType(javaClass, "camel.component", (overrideComponentName != null ? overrideComponentName : model.getScheme()).toLowerCase(Locale.US)));
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName);
        this.writeAdditionalSpringMetaData("camel", "component", (overrideComponentName != null ? overrideComponentName : model.getScheme()).toLowerCase(Locale.US));
    }

    private void createDataFormatAutoConfigurationSource(String packageName, DataFormatModel model, List<String> dataFormatAliases, boolean hasOptions, String overrideDataFormatName) throws MojoFailureException {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("DataFormat", "DataFormatAutoConfiguration");
        ((JavaClassSource)javaClass.setPackage(packageName)).setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        javaClass.getJavaDoc().setFullText(doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(ConditionalOnBean.class).setStringValue("type", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(Conditional.class).setLiteralValue(name + ".Condition.class");
        javaClass.addAnnotation(AutoConfigureAfter.class).setStringValue("name", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        String configurationName = name.replace("DataFormatAutoConfiguration", "DataFormatConfiguration");
        if (hasOptions) {
            AnnotationSource ann = javaClass.addAnnotation(EnableConfigurationProperties.class);
            ann.setLiteralValue("value", configurationName + ".class");
            javaClass.addImport("java.util.HashMap");
            javaClass.addImport("java.util.Map");
            javaClass.addImport("org.apache.camel.util.IntrospectionSupport");
        }
        javaClass.addImport("org.apache.camel.CamelContextAware");
        javaClass.addImport(model.getJavaType());
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.RuntimeCamelException");
        javaClass.addImport("org.apache.camel.spi.DataFormat");
        javaClass.addImport("org.apache.camel.spi.DataFormatFactory");
        String body = SpringBootAutoConfigurationMojo.createDataFormatBody(model.getShortJavaType(), hasOptions);
        String methodName = "configure" + model.getShortJavaType() + "Factory";
        MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(methodName)).setPublic()).setBody(body).setReturnType("org.apache.camel.spi.DataFormatFactory");
        method.addParameter("CamelContext", "camelContext").setFinal(true);
        if (hasOptions) {
            method.addParameter(configurationName, "configuration").setFinal(true);
        }
        String[] springBeanAliases = (String[])dataFormatAliases.stream().map(alias -> alias + "-dataformat-factory").toArray(String[]::new);
        method.addAnnotation(Bean.class).setStringArrayValue("name", springBeanAliases);
        method.addAnnotation(ConditionalOnClass.class).setLiteralValue("value", "CamelContext.class");
        method.addAnnotation(ConditionalOnMissingBean.class).setLiteralValue("value", model.getShortJavaType() + ".class");
        javaClass.addNestedType((JavaSource)this.createConditionType(javaClass, "camel.dataformat", (overrideDataFormatName != null ? overrideDataFormatName : model.getName()).toLowerCase(Locale.US)));
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName);
        this.writeAdditionalSpringMetaData("camel", "dataformat", (overrideDataFormatName != null ? overrideDataFormatName : model.getName()).toLowerCase(Locale.US));
    }

    private void createLanguageAutoConfigurationSource(String packageName, LanguageModel model, List<String> languageAliases, boolean hasOptions, String overrideLanguageName) throws MojoFailureException {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Language", "LanguageAutoConfiguration");
        ((JavaClassSource)javaClass.setPackage(packageName)).setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        javaClass.getJavaDoc().setFullText(doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(ConditionalOnBean.class).setStringValue("type", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(Conditional.class).setLiteralValue(name + ".Condition.class");
        javaClass.addAnnotation(AutoConfigureAfter.class).setStringValue("name", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        String configurationName = name.replace("LanguageAutoConfiguration", "LanguageConfiguration");
        if (hasOptions) {
            AnnotationSource ann = javaClass.addAnnotation(EnableConfigurationProperties.class);
            ann.setLiteralValue("value", configurationName + ".class");
            javaClass.addImport("java.util.HashMap");
            javaClass.addImport("java.util.Map");
            javaClass.addImport("org.apache.camel.util.IntrospectionSupport");
        }
        javaClass.addImport("org.apache.camel.CamelContextAware");
        javaClass.addImport(model.getJavaType());
        javaClass.addImport("org.apache.camel.CamelContext");
        String body = SpringBootAutoConfigurationMojo.createLanguageBody(model.getShortJavaType(), hasOptions);
        String methodName = "configure" + model.getShortJavaType();
        MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(methodName)).setPublic()).setBody(body).setReturnType(model.getShortJavaType()).addThrows(Exception.class);
        method.addParameter("CamelContext", "camelContext");
        method.addParameter(configurationName, "configuration");
        String[] springBeanAliases = (String[])languageAliases.stream().map(alias -> alias + "-language").toArray(String[]::new);
        method.addAnnotation(Bean.class).setStringArrayValue("name", springBeanAliases);
        method.addAnnotation(Scope.class).setStringValue("prototype");
        method.addAnnotation(ConditionalOnClass.class).setLiteralValue("value", "CamelContext.class");
        method.addAnnotation(ConditionalOnMissingBean.class).setLiteralValue("value", model.getShortJavaType() + ".class");
        javaClass.addNestedType((JavaSource)this.createConditionType(javaClass, "camel.language", (overrideLanguageName != null ? overrideLanguageName : model.getName()).toLowerCase(Locale.US)));
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName);
        this.writeAdditionalSpringMetaData("camel", "language", (overrideLanguageName != null ? overrideLanguageName : model.getName()).toLowerCase(Locale.US));
    }

    private void createComponentSpringFactorySource(String packageName, ComponentModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Component", "ComponentAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void createDataFormatSpringFactorySource(String packageName, DataFormatModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("DataFormat", "DataFormatAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void createLanguageSpringFactorySource(String packageName, LanguageModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Language", "LanguageAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private static String createComponentBody(String shortJavaType, boolean hasOptions) {
        StringBuilder sb = new StringBuilder();
        sb.append(shortJavaType).append(" component = new ").append(shortJavaType).append("();").append("\n");
        sb.append("component.setCamelContext(camelContext);\n");
        sb.append("\n");
        if (hasOptions) {
            sb.append("Map<String, Object> parameters = new HashMap<>();\n");
            sb.append("IntrospectionSupport.getProperties(configuration, parameters, null, false);\n");
            sb.append("\n");
            sb.append("for (Map.Entry<String, Object> entry : parameters.entrySet()) {\n");
            sb.append("    Object value = entry.getValue();\n");
            sb.append("    Class<?> paramClass = value.getClass();\n");
            sb.append("    if (paramClass.getName().endsWith(\"NestedConfiguration\")) {\n");
            sb.append("        Class nestedClass = null;\n");
            sb.append("        try {\n");
            sb.append("            nestedClass = (Class) paramClass.getDeclaredField(\"CAMEL_NESTED_CLASS\").get(null);\n");
            sb.append("            HashMap<String, Object> nestedParameters = new HashMap<>();\n");
            sb.append("            IntrospectionSupport.getProperties(value, nestedParameters, null, false);\n");
            sb.append("            Object nestedProperty = nestedClass.newInstance();\n");
            sb.append("            IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), nestedProperty, nestedParameters);\n");
            sb.append("            entry.setValue(nestedProperty);\n");
            sb.append("        } catch (NoSuchFieldException e) {\n");
            sb.append("            // ignore, class must not be a nested configuration class after all\n");
            sb.append("        }\n");
            sb.append("    }\n");
            sb.append("}\n");
            sb.append("IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), component, parameters);\n");
        }
        sb.append("\n");
        sb.append("return component;");
        return sb.toString();
    }

    private static String createDataFormatBody(String shortJavaType, boolean hasOptions) {
        StringBuilder sb = new StringBuilder();
        sb.append("return new DataFormatFactory() {\n");
        sb.append("    public DataFormat newInstance() {\n");
        sb.append("        ").append(shortJavaType).append(" dataformat = new ").append(shortJavaType).append("();").append("\n");
        sb.append("        if (CamelContextAware.class.isAssignableFrom(").append(shortJavaType).append(".class)) {\n");
        sb.append("            CamelContextAware contextAware = CamelContextAware.class.cast(dataformat);\n");
        sb.append("            if (contextAware != null) {\n");
        sb.append("                contextAware.setCamelContext(camelContext);\n");
        sb.append("            }\n");
        sb.append("        }\n");
        if (hasOptions) {
            sb.append("\n");
            sb.append("        try {\n");
            sb.append("            Map<String, Object> parameters = new HashMap<>();\n");
            sb.append("            IntrospectionSupport.getProperties(configuration, parameters, null, false);\n");
            sb.append("            IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), dataformat, parameters);\n");
            sb.append("        } catch (Exception e) {\n");
            sb.append("            throw new RuntimeCamelException(e);\n");
            sb.append("        }\n");
        }
        sb.append("\n");
        sb.append("        return dataformat;\n");
        sb.append("    }\n");
        sb.append("};\n");
        return sb.toString();
    }

    private static String createLanguageBody(String shortJavaType, boolean hasOptions) {
        StringBuilder sb = new StringBuilder();
        sb.append(shortJavaType).append(" language = new ").append(shortJavaType).append("();").append("\n");
        sb.append("if (CamelContextAware.class.isAssignableFrom(").append(shortJavaType).append(".class)) {\n");
        sb.append("    CamelContextAware contextAware = CamelContextAware.class.cast(language);\n");
        sb.append("    if (contextAware != null) {\n");
        sb.append("        contextAware.setCamelContext(camelContext);\n");
        sb.append("    }\n");
        sb.append("}\n");
        if (hasOptions) {
            sb.append("\n");
            sb.append("Map<String, Object> parameters = new HashMap<>();\n");
            sb.append("IntrospectionSupport.getProperties(configuration, parameters, null, false);\n");
            sb.append("\n");
            sb.append("IntrospectionSupport.setProperties(camelContext, camelContext.getTypeConverter(), language, parameters);\n");
        }
        sb.append("\n");
        sb.append("return language;");
        return sb.toString();
    }

    private static void sortImports(JavaClassSource javaClass) {
        List imports = javaClass.getImports();
        ArrayList<String> names = new ArrayList<String>();
        for (Import imp : imports) {
            names.add(imp.getQualifiedName());
        }
        Collections.sort(names, (s1, s2) -> {
            if (s1.startsWith("java.")) {
                s1 = "___" + s1;
            }
            if (s2.startsWith("java.")) {
                s2 = "___" + s2;
            }
            if (s1.startsWith("javax.")) {
                s1 = "__" + s1;
            }
            if (s2.startsWith("javax.")) {
                s2 = "__" + s2;
            }
            if (s1.startsWith("org.w3c.")) {
                s1 = "_" + s1;
            }
            if (s2.startsWith("org.w3c.")) {
                s2 = "_" + s2;
            }
            return s1.compareTo((String)s2);
        });
        for (String name : names) {
            javaClass.removeImport(name);
        }
        for (String name : names) {
            javaClass.addImport(name);
        }
    }

    private static String sourceToString(JavaClassSource javaClass) {
        String code = Formatter.format((JavaClassSource)javaClass);
        code = code.replaceAll("\\t", "    ");
        return code;
    }

    private static String loadModelJson(Set<File> jsonFiles, String modelName) {
        try {
            for (File file : jsonFiles) {
                String json;
                boolean isModel;
                if (!file.getName().equals(modelName + ".json") || !(isModel = (json = PackageHelper.loadText(new FileInputStream(file))).contains("\"kind\": \"model\""))) continue;
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String loadComponentJson(Set<File> jsonFiles, String componentName) {
        try {
            for (File file : jsonFiles) {
                String json;
                boolean isComponent;
                if (!file.getName().equals(componentName + ".json") || !(isComponent = (json = PackageHelper.loadText(new FileInputStream(file))).contains("\"kind\": \"component\""))) continue;
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String loadDataFormatJson(Set<File> jsonFiles, String dataFormatName) {
        try {
            for (File file : jsonFiles) {
                String json;
                boolean isDataFormat;
                if (!file.getName().equals(dataFormatName + ".json") || !(isDataFormat = (json = PackageHelper.loadText(new FileInputStream(file))).contains("\"kind\": \"dataformat\""))) continue;
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String loadLanguageJson(Set<File> jsonFiles, String languageName) {
        try {
            for (File file : jsonFiles) {
                String json;
                boolean isLanguage;
                if (!file.getName().equals(languageName + ".json") || !(isLanguage = (json = PackageHelper.loadText(new FileInputStream(file))).contains("\"kind\": \"language\""))) continue;
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static ComponentModel generateComponentModel(String componentName, String json) {
        Object option;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        ComponentModel component = new ComponentModel(true);
        component.setScheme(JSonSchemaHelper.getSafeValue("scheme", rows));
        component.setSyntax(JSonSchemaHelper.getSafeValue("syntax", rows));
        component.setAlternativeSyntax(JSonSchemaHelper.getSafeValue("alternativeSyntax", rows));
        component.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        component.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        component.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        component.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        component.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        component.setConsumerOnly(JSonSchemaHelper.getSafeValue("consumerOnly", rows));
        component.setProducerOnly(JSonSchemaHelper.getSafeValue("producerOnly", rows));
        component.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        component.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        component.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        component.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("componentProperties", json, true);
        for (Map<String, String> row : rows) {
            option = new ComponentOptionModel();
            ((ComponentOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((ComponentOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((ComponentOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((ComponentOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((ComponentOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((ComponentOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((ComponentOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            ((ComponentOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((ComponentOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            component.addComponentOption((ComponentOptionModel)option);
        }
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            option = new EndpointOptionModel();
            ((EndpointOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((EndpointOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((EndpointOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((EndpointOptionModel)option).setGroup(JSonSchemaHelper.getSafeValue("group", row));
            ((EndpointOptionModel)option).setRequired(JSonSchemaHelper.getSafeValue("required", row));
            ((EndpointOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((EndpointOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((EndpointOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            ((EndpointOptionModel)option).setPrefix(JSonSchemaHelper.getSafeValue("prefix", row));
            ((EndpointOptionModel)option).setMultiValue(JSonSchemaHelper.getSafeValue("multiValue", row));
            ((EndpointOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((EndpointOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((EndpointOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            ((EndpointOptionModel)option).setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            component.addEndpointOption((EndpointOptionModel)option);
        }
        return component;
    }

    private static DataFormatModel generateDataFormatModel(String dataFormatName, String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
        DataFormatModel dataFormat = new DataFormatModel();
        dataFormat.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        dataFormat.setName(JSonSchemaHelper.getSafeValue("name", rows));
        dataFormat.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        dataFormat.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        dataFormat.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        dataFormat.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        dataFormat.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        dataFormat.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        dataFormat.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        dataFormat.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        dataFormat.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            DataFormatOptionModel option = new DataFormatOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            dataFormat.addDataFormatOption(option);
        }
        return dataFormat;
    }

    private static LanguageModel generateLanguageModel(String languageName, String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
        LanguageModel language = new LanguageModel();
        language.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        language.setName(JSonSchemaHelper.getSafeValue("name", rows));
        language.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        language.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        language.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        language.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        language.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        language.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        language.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        language.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        language.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            LanguageOptionModel option = new LanguageOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            language.addLanguageOption(option);
        }
        return language;
    }

    private OtherModel generateOtherModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
        OtherModel model = new OtherModel();
        model.setName(JSonSchemaHelper.getSafeValue("name", rows));
        model.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        model.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        model.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        model.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        model.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            OtherOptionModel option = new OtherOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setGroup(JSonSchemaHelper.getSafeValue("group", row));
            option.setRequired(JSonSchemaHelper.getSafeValue("required", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            option.setEnums(JSonSchemaHelper.getSafeValue("enums", row));
            model.addOptionModel(option);
        }
        return model;
    }

    private List<String> findComponentNames() {
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Resource r : this.project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(this.project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/component")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                componentNames.add(name);
            }
        }
        return componentNames;
    }

    private List<String> findDataFormatNames() {
        ArrayList<String> dataFormatNames = new ArrayList<String>();
        for (Resource r : this.project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(this.project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/dataformat")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                dataFormatNames.add(name);
            }
        }
        return dataFormatNames;
    }

    private List<String> findLanguageNames() {
        ArrayList<String> languageNames = new ArrayList<String>();
        for (Resource r : this.project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(this.project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/language")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                languageNames.add(name);
            }
        }
        return languageNames;
    }

    private void writeSourceIfChanged(JavaClassSource source, String fileName) throws MojoFailureException {
        File target = new File(SpringBootHelper.starterSrcDir(this.baseDir, this.project.getArtifactId()), fileName);
        this.deleteFileOnMainArtifact(target);
        try {
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");
            String header = PackageHelper.loadText(is);
            String code = SpringBootAutoConfigurationMojo.sourceToString(source);
            code = header + code;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            if (target.exists()) {
                String existing = FileUtils.readFileToString((File)target);
                if (!code.equals(existing)) {
                    FileUtils.write((File)target, (CharSequence)code, (boolean)false);
                    this.getLog().info((CharSequence)("Updated existing file: " + target));
                } else {
                    this.getLog().debug((CharSequence)("No changes to existing file: " + target));
                }
            } else {
                FileUtils.write((File)target, (CharSequence)code);
                this.getLog().info((CharSequence)("Created file: " + target));
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }

    private void writeComponentSpringFactorySource(String packageName, String name) throws MojoFailureException {
        StringBuilder sb = new StringBuilder();
        sb.append("org.springframework.boot.autoconfigure.EnableAutoConfiguration=\\\n");
        String lineToAdd = packageName + "." + name + "\n";
        sb.append(lineToAdd);
        String fileName = "META-INF/spring.factories";
        File target = new File(SpringBootHelper.starterResourceDir(this.baseDir, this.project.getArtifactId()), fileName);
        this.deleteFileOnMainArtifact(target);
        if (target.exists()) {
            try {
                boolean found = false;
                List lines = FileUtils.readLines((File)target);
                for (String line : lines) {
                    if (!line.contains(name)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.getLog().debug((CharSequence)("No changes to existing file: " + target));
                }
                int lastLine = 0;
                for (int i = lines.size() - 1; i >= 0; --i) {
                    String line = (String)lines.get(i);
                    if (line.trim().isEmpty()) continue;
                    line = line + ",\\";
                    lines.set(i, line);
                    lastLine = i;
                    break;
                }
                lines.add(lastLine + 1, lineToAdd);
                StringBuilder code = new StringBuilder();
                for (String line : lines) {
                    code.append(line).append("\n");
                }
                FileUtils.write((File)target, (CharSequence)code.toString(), (boolean)false);
                this.getLog().info((CharSequence)("Updated existing file: " + target));
            }
            catch (Exception e) {
                throw new MojoFailureException("IOError with file " + target, (Throwable)e);
            }
        } else {
            try {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header.txt");
                String header = PackageHelper.loadText(is);
                String code = sb.toString();
                code = header + "\n" + code;
                this.getLog().debug((CharSequence)("Source code generated:\n" + code));
                FileUtils.write((File)target, (CharSequence)code);
                this.getLog().info((CharSequence)("Created file: " + target));
            }
            catch (Exception e) {
                throw new MojoFailureException("IOError with file " + target, (Throwable)e);
            }
        }
    }

    private void writeAdditionalSpringMetaData(String prefix, String type, String name) throws MojoFailureException {
        String fullQualifiedName = prefix + "." + type + "." + name + ".enabled";
        String fileName = "META-INF/additional-spring-configuration-metadata.json";
        File target = new File(SpringBootHelper.starterResourceDir(this.baseDir, this.project.getArtifactId()), fileName);
        this.deleteFileOnMainArtifact(target);
        try {
            BufferedReader br;
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            HashMap map = null;
            ArrayList properties = null;
            if (target.exists() && (properties = (ArrayList)(map = (HashMap)gson.fromJson((Reader)(br = new BufferedReader(new FileReader(target))), Map.class)).get("properties")) != null && properties.stream().anyMatch(m -> fullQualifiedName.equals(m.get("name")))) {
                this.getLog().debug((CharSequence)("No changes to existing file: " + target));
                return;
            }
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("name", fullQualifiedName);
            meta.put("type", "java.lang.Boolean");
            meta.put("defaultValue", true);
            meta.put("description", "Enable " + name + " " + type);
            if (properties == null) {
                properties = new ArrayList(1);
            }
            if (map == null) {
                map = new HashMap();
            }
            properties.add(meta);
            map.put("properties", properties);
            FileUtils.write((File)target, (CharSequence)gson.toJson(map));
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }

    private void deleteFileOnMainArtifact(File starterFile) {
    }

    private JavaClassSource createConditionType(JavaClassSource parentClass, String prefix, String type) {
        parentClass.addImport(ConditionMessage.class);
        parentClass.addImport(ConditionContext.class);
        parentClass.addImport(ConditionOutcome.class);
        parentClass.addImport(RelaxedPropertyResolver.class);
        parentClass.addImport(AnnotatedTypeMetadata.class);
        parentClass.addImport(SpringBootCondition.class);
        JavaClassSource condition = (JavaClassSource)Roaster.create(JavaClassSource.class);
        condition.setName("Condition");
        condition.extendSuperType(SpringBootCondition.class);
        condition.setPublic();
        condition.setStatic(true);
        condition.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        String fullQualifiedType = prefix.endsWith(".") ? prefix + type : prefix + "." + type;
        MethodSource isEnabled = condition.addMethod();
        isEnabled.setName("isEnabled");
        isEnabled.setPrivate();
        isEnabled.addParameter(ConditionContext.class, "context");
        isEnabled.addParameter(String.class, "prefix");
        isEnabled.addParameter(Boolean.TYPE, "defaultValue");
        isEnabled.setReturnType(Boolean.TYPE);
        isEnabled.setBody("RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(context.getEnvironment(), prefix);\n" + "return resolver.getProperty(\"enabled\", Boolean.class, defaultValue);");
        MethodSource matchMethod = condition.getMethod("getMatchOutcome", new Class[]{ConditionContext.class, AnnotatedTypeMetadata.class});
        matchMethod.setBody("boolean groupEnabled = isEnabled(conditionContext, \"" + prefix + ".\", true);\n" + "ConditionMessage.Builder message = ConditionMessage.forCondition(\"" + fullQualifiedType + "\");\n" + "if (isEnabled(conditionContext, \"" + fullQualifiedType + ".\", groupEnabled)) {\n" + "    return ConditionOutcome.match(message.because(\"enabled\"));\n" + "}\n" + "return ConditionOutcome.noMatch(message.because(\"not enabled\"));\n");
        return condition;
    }

    static {
        PRIMITIVEMAP.put("boolean", "java.lang.Boolean");
        PRIMITIVEMAP.put("char", "java.lang.Character");
        PRIMITIVEMAP.put("long", "java.lang.Long");
        PRIMITIVEMAP.put("int", "java.lang.Integer");
        PRIMITIVEMAP.put("integer", "java.lang.Integer");
        PRIMITIVEMAP.put("byte", "java.lang.Byte");
        PRIMITIVEMAP.put("short", "java.lang.Short");
        PRIMITIVEMAP.put("double", "java.lang.Double");
        PRIMITIVEMAP.put("float", "java.lang.Float");
        JAVA_LANG_TYPES = Arrays.asList("Boolean", "Byte", "Character", "Class", "Double", "Float", "Integer", "Long", "Object", "Short", "String");
        IGNORE_MODULES = new String[]{"camel-grape", "camel-connector"};
    }

    private class ResolvedProperty {
        private String propertyType;
        private PropertySource<JavaClassSource> propertySource;

        ResolvedProperty(String propertyType, PropertySource<JavaClassSource> propertySource) {
            this.propertyType = propertyType;
            this.propertySource = propertySource;
        }
    }
}

