/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Properties;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public class PackageOtherMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File otherOutDir;
    protected File schemaOutDir;
    private MavenProjectHelper projectHelper;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageOtherMojo.prepareOthers(this.getLog(), this.project, this.projectHelper, this.otherOutDir, this.schemaOutDir, this.buildContext);
    }

    public static void prepareOthers(Log log, MavenProject project, MavenProjectHelper projectHelper, File otherOutDir, File schemaOutDir, BuildContext buildContext) throws MojoExecutionException {
        for (Resource r : project.getBuild().getResources()) {
            File comp;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(project.getBasedir(), r.getDirectory());
            }
            if ((comp = new File(f, "META-INF/services/org/apache/camel/component")).exists() && comp.isDirectory()) {
                return;
            }
            File df = new File(f, "META-INF/services/org/apache/camel/dataformat");
            if (df.exists() && df.isDirectory()) {
                return;
            }
            File lan = new File(f, "META-INF/services/org/apache/camel/language");
            if (!lan.exists() || !lan.isDirectory()) continue;
            return;
        }
        if (projectHelper != null) {
            projectHelper.addResource(project, otherOutDir.getPath(), Collections.singletonList("**/other.properties"), Collections.emptyList());
        }
        if (!(PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/component") || PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/dataformat") || PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/language"))) {
            return;
        }
        String name = project.getArtifactId();
        if (name.startsWith("camel-")) {
            name = name.substring(6);
        }
        try {
            OtherModel otherModel = new OtherModel();
            otherModel.setName(name);
            otherModel.setGroupId(project.getGroupId());
            otherModel.setArtifactId(project.getArtifactId());
            otherModel.setVersion(project.getVersion());
            otherModel.setDescription(project.getDescription());
            if (project.getName() != null && project.getName().contains("(deprecated)")) {
                otherModel.setDeprecated("true");
            } else {
                otherModel.setDeprecated("false");
            }
            otherModel.setFirstVersion(project.getProperties().getProperty("firstVersion"));
            otherModel.setLabel(project.getProperties().getProperty("label"));
            String title = project.getProperties().getProperty("title");
            if (title == null) {
                title = StringHelper.camelDashToTitle(name);
            }
            otherModel.setTitle(title);
            log.debug((CharSequence)("Model " + otherModel));
            File dir = schemaOutDir;
            dir.mkdirs();
            File out = new File(dir, name + ".json");
            OutputStream fos = buildContext.newFileOutputStream(out);
            String json = PackageOtherMojo.createJsonSchema(otherModel);
            fos.write(json.getBytes());
            fos.close();
            buildContext.refresh(out);
            log.debug((CharSequence)("Generated " + out + " containing JSon schema for " + name + " other"));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading language model from camel-core. Reason: " + e, e);
        }
        File camelMetaDir = new File(otherOutDir, "META-INF/services/org/apache/camel/");
        Properties properties = new Properties();
        properties.put("name", name);
        properties.put("groupId", project.getGroupId());
        properties.put("artifactId", project.getArtifactId());
        properties.put("version", project.getVersion());
        properties.put("projectName", project.getName());
        if (project.getDescription() != null) {
            properties.put("projectDescription", project.getDescription());
        }
        camelMetaDir.mkdirs();
        File outFile = new File(camelMetaDir, "other.properties");
        if (outFile.exists()) {
            try {
                Properties existing = new Properties();
                FileInputStream is = new FileInputStream(outFile);
                existing.load(is);
                ((InputStream)is).close();
                if (existing.equals(properties)) {
                    log.debug((CharSequence)"No changes detected");
                    return;
                }
            }
            catch (IOException existing) {
                // empty catch block
            }
        }
        try {
            OutputStream os = buildContext.newFileOutputStream(outFile);
            properties.store(os, "Generated by camel-package-maven-plugin");
            os.close();
            log.info((CharSequence)("Generated " + outFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write properties to " + outFile + ". Reason: " + e, (Exception)e);
        }
    }

    private static String createJsonSchema(OtherModel otherModel) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"other\": {");
        buffer.append("\n    \"name\": \"").append(otherModel.getName()).append("\",");
        buffer.append("\n    \"kind\": \"").append("other").append("\",");
        if (otherModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(otherModel.getTitle()).append("\",");
        }
        if (otherModel.getDescription() != null) {
            buffer.append("\n    \"description\": \"").append(otherModel.getDescription()).append("\",");
        }
        buffer.append("\n    \"deprecated\": \"").append(otherModel.getDeprecated()).append("\",");
        if (otherModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(otherModel.getFirstVersion()).append("\",");
        }
        if (otherModel.getLabel() != null) {
            buffer.append("\n    \"label\": \"").append(otherModel.getLabel()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(otherModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(otherModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(otherModel.getVersion()).append("\"");
        buffer.append("\n  }");
        buffer.append("\n}");
        return buffer.toString();
    }

    private static class OtherModel {
        private String name;
        private String title;
        private String description;
        private String deprecated;
        private String firstVersion;
        private String label;
        private String groupId;
        private String artifactId;
        private String version;

        private OtherModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }

        public String getFirstVersion() {
            return this.firstVersion;
        }

        public void setFirstVersion(String firstVersion) {
            this.firstVersion = firstVersion;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "OtherModel[name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
        }
    }
}

