/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.opensearch;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.opensearch.OpensearchComponent;
import org.apache.camel.component.opensearch.OpensearchConfiguration;
import org.apache.camel.component.opensearch.OpensearchConstants;
import org.apache.camel.component.opensearch.OpensearchProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.opensearch.client.RestClient;

@UriEndpoint(firstVersion="4.0.0", scheme="opensearch", title="OpenSearch", syntax="opensearch:clusterName", producerOnly=true, category={Category.SEARCH, Category.MONITORING}, headersClass=OpensearchConstants.class)
public class OpensearchEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriParam
    private final OpensearchConfiguration configuration;
    private final RestClient client;

    public OpensearchEndpoint(String uri, OpensearchComponent component, OpensearchConfiguration config, RestClient client) {
        super(uri, (Component)component);
        this.configuration = config;
        this.client = client;
    }

    public OpensearchConfiguration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() {
        return new OpensearchProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Cannot consume from an OpenSearch: " + this.getEndpointUri());
    }

    public RestClient getClient() {
        return this.client;
    }

    public String getServiceUrl() {
        return this.configuration.getHostAddresses();
    }

    public String getServiceProtocol() {
        return "opensearch";
    }
}

