/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi.validator.client;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.report.JsonValidationReportFormat;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.SimpleValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.rest.openapi.RestOpenApiComponent;
import org.apache.camel.component.rest.openapi.RestOpenApiHelper;
import org.apache.camel.http.base.HttpHeaderFilterStrategy;
import org.apache.camel.spi.RestClientRequestValidator;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="rest-client-request-validator-factory")
public class OpenApiRestClientRequestValidator
implements RestClientRequestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiRestClientRequestValidator.class);
    private final HttpHeaderFilterStrategy filter = new HttpHeaderFilterStrategy();

    public OpenApiRestClientRequestValidator() {
        this.filter.getOutFilter().add("accept");
        this.filter.getOutFilter().add("authorization");
        this.filter.getOutFilter().add("content-encoding");
        this.filter.getOutFilter().add("cookie");
        this.filter.getOutFilter().add("origin");
        this.filter.getOutFilter().add("user-agent");
    }

    public RestClientRequestValidator.ValidationError validate(Exchange exchange, RestClientRequestValidator.ValidationContext validationContent) {
        OpenApiInteractionValidator validator;
        ValidationReport report;
        OpenAPI openAPI = (OpenAPI)exchange.getProperty("CamelRestOpenAPI", OpenAPI.class);
        if (openAPI == null) {
            return null;
        }
        String method = (String)exchange.getMessage().getHeader("CamelHttpMethod", String.class);
        String path = (String)exchange.getMessage().getHeader("CamelHttpPath", String.class);
        RestOpenApiComponent comp = (RestOpenApiComponent)exchange.getContext().hasComponent("rest-openapi");
        String basePath = RestOpenApiHelper.determineBasePath((CamelContext)exchange.getContext(), (RestOpenApiComponent)comp, null, (OpenAPI)openAPI);
        if (path != null && path.startsWith(basePath)) {
            path = path.substring(basePath.length());
        }
        String accept = (String)exchange.getMessage().getHeader("Accept", String.class);
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        String body = MessageHelper.extractBodyAsString((Message)exchange.getIn());
        SimpleRequest.Builder builder = new SimpleRequest.Builder(method, path, false);
        if (contentType != null) {
            builder.withContentType(contentType);
        }
        if (accept != null) {
            builder.withAccept(new String[]{accept});
        }
        if (body != null) {
            builder.withBody(body);
        }
        for (Map.Entry header : exchange.getMessage().getHeaders().entrySet()) {
            String[] key = (String[])header.getKey();
            Object value = header.getValue();
            int customHeader = !OpenApiRestClientRequestValidator.startsWithIgnoreCase((String)key, "Camel") && !this.filter.applyFilterToCamelHeaders((String)key, value, exchange) ? 1 : 0;
            if (customHeader == 0) continue;
            builder.withHeader((String)key, new String[]{(String)exchange.getMessage().getHeader((String)key, String.class)});
        }
        String query = (String)exchange.getMessage().getHeader("CamelHttpQuery", String.class);
        if (query != null) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] keyValue = param.split("=");
                if (keyValue.length == 2) {
                    builder.withQueryParam(keyValue[0], new String[]{keyValue[1]});
                    continue;
                }
                if (keyValue.length != 1) continue;
                builder.withQueryParam(keyValue[0], new String[]{""});
            }
        }
        LevelResolver.Builder lr = LevelResolver.create();
        RestConfiguration rc = exchange.getContext().getRestConfiguration();
        if (rc.getValidationLevels() != null) {
            for (Map.Entry e : rc.getValidationLevels().entrySet()) {
                String key = (String)e.getKey();
                ValidationReport.Level level = ValidationReport.Level.valueOf((String)((String)e.getValue()));
                if ("defaultLevel".equalsIgnoreCase(key)) {
                    lr.withDefaultLevel(level);
                    continue;
                }
                lr.withLevel(key, level);
            }
        }
        if ((report = (validator = OpenApiInteractionValidator.createFor((OpenAPI)openAPI).withLevelResolver(lr.build()).build()).validateRequest((Request)builder.build())).hasErrors() || LOG.isDebugEnabled()) {
            String msg = accept != null && accept.contains("application/json") ? JsonValidationReportFormat.getInstance().apply(report) : SimpleValidationReportFormat.getInstance().apply(report);
            LOG.debug("Client Request Validation: {}", (Object)msg);
            if (report.hasErrors()) {
                return new RestClientRequestValidator.ValidationError(400, msg);
            }
        }
        return null;
    }

    private static boolean startsWithIgnoreCase(String s, String prefix) {
        return s.regionMatches(true, 0, prefix, 0, prefix.length());
    }
}

