/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.StartupStep;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.DefaultRestApiResponseAdapter;
import org.apache.camel.openapi.RestApiResponseAdapter;
import org.apache.camel.openapi.RestOpenApiSupport;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class RestOpenApiProcessor
extends ServiceSupport
implements Processor,
CamelContextAware {
    private final RestApiResponseAdapter jsonAdapter = new DefaultRestApiResponseAdapter();
    private final RestApiResponseAdapter yamlAdapter = new DefaultRestApiResponseAdapter();
    private CamelContext camelContext;
    private final BeanConfig openApiConfig;
    private final RestOpenApiSupport support;
    private final RestConfiguration configuration;

    public RestOpenApiProcessor(Map<String, Object> parameters, RestConfiguration configuration) {
        this.configuration = configuration;
        this.support = new RestOpenApiSupport();
        this.openApiConfig = new BeanConfig();
        if (parameters == null) {
            parameters = Collections.emptyMap();
        }
        this.support.initOpenApi(this.openApiConfig, parameters);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        if (!this.configuration.isUseXForwardHeaders()) {
            StartupStepRecorder recorder = this.camelContext.getCamelContextExtension().getStartupStepRecorder();
            StartupStep step = recorder.beginStep(RestOpenApiProcessor.class, "openapi", "Generating OpenAPI specification");
            try {
                this.support.renderResourceListing(this.camelContext, this.jsonAdapter, this.openApiConfig, true, this.camelContext.getClassResolver(), this.configuration, null);
                this.yamlAdapter.setOpenApi(this.jsonAdapter.getOpenApi());
                this.support.renderResourceListing(this.camelContext, this.yamlAdapter, this.openApiConfig, false, this.camelContext.getClassResolver(), this.configuration, null);
            }
            finally {
                recorder.endStep(step);
            }
        }
    }

    public void process(Exchange exchange) throws Exception {
        RestApiResponseAdapter adapter;
        if (!this.isRunAllowed()) {
            throw new RejectedExecutionException();
        }
        String route = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        String accept = (String)exchange.getIn().getHeader("Accept", String.class);
        boolean json = false;
        boolean yaml = false;
        if (route != null && route.endsWith(".json")) {
            json = true;
        } else if (route != null && route.endsWith(".yaml")) {
            yaml = true;
        }
        if (accept != null && !json && !yaml) {
            json = accept.toLowerCase(Locale.US).contains("json");
            yaml = accept.toLowerCase(Locale.US).contains("yaml");
        }
        if (!json && !yaml) {
            json = true;
        }
        if (this.configuration.isUseXForwardHeaders()) {
            adapter = new DefaultRestApiResponseAdapter();
            this.support.renderResourceListing(this.camelContext, adapter, this.openApiConfig, json, this.camelContext.getClassResolver(), this.configuration, exchange);
        } else {
            adapter = json ? this.jsonAdapter : this.yamlAdapter;
        }
        adapter.copyResult(exchange);
    }
}

