/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.ExchangeRestApiResponseAdapter;
import org.apache.camel.openapi.RestOpenApiSupport;
import org.apache.camel.spi.RestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOpenApiProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(RestOpenApiProcessor.class);
    private final BeanConfig openApiConfig;
    private final RestOpenApiSupport support;
    private final RestConfiguration configuration;

    public RestOpenApiProcessor(Map<String, Object> parameters, RestConfiguration configuration) {
        this.configuration = configuration;
        this.support = new RestOpenApiSupport();
        this.openApiConfig = new BeanConfig();
        if (parameters == null) {
            parameters = Collections.EMPTY_MAP;
        }
        this.support.initOpenApi(this.openApiConfig, parameters);
    }

    public void process(Exchange exchange) throws Exception {
        String route = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        String accept = (String)exchange.getIn().getHeader("Accept", String.class);
        ExchangeRestApiResponseAdapter adapter = new ExchangeRestApiResponseAdapter(exchange);
        boolean json = false;
        boolean yaml = false;
        if (route != null && route.endsWith("/openapi.json")) {
            json = true;
        } else if (route != null && route.endsWith("/openapi.yaml")) {
            yaml = true;
        }
        if (accept != null && !json && !yaml) {
            json = accept.toLowerCase(Locale.US).contains("json");
            yaml = accept.toLowerCase(Locale.US).contains("yaml");
        }
        if (!json && !yaml) {
            json = true;
        }
        try {
            this.support.renderResourceListing(exchange.getContext(), adapter, this.openApiConfig, json, yaml, exchange.getIn().getHeaders(), exchange.getContext().getClassResolver(), this.configuration);
        }
        catch (Exception e) {
            LOG.warn("Error rendering OpenApi API due {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

