/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30SchemaDefinition;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.oas.models.media.ArraySchema;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestModelConverters {
    private static final Logger LOG = LoggerFactory.getLogger(RestModelConverters.class);
    private static final ModelConverters MODEL_CONVERTERS = ModelConverters.getInstance();

    public List<? extends OasSchema> readClass(OasDocument oasDocument, Class<?> clazz) {
        if (clazz.equals(File.class)) {
            return null;
        }
        if (oasDocument instanceof Oas20Document) {
            return this.readClassOas20((Oas20Document)oasDocument, clazz);
        }
        if (oasDocument instanceof Oas30Document) {
            return this.readClassOas30((Oas30Document)oasDocument, clazz);
        }
        return null;
    }

    private List<? extends OasSchema> readClassOas30(Oas30Document oasDocument, Class<?> clazz) {
        String name = clazz.getName();
        if (!name.contains(".")) {
            return null;
        }
        if (oasDocument.components == null) {
            oasDocument.components = oasDocument.createComponents();
        }
        Map swaggerModel = MODEL_CONVERTERS.readAll(clazz);
        swaggerModel.forEach((key, schema) -> {
            Oas30SchemaDefinition model = oasDocument.components.createSchemaDefinition(key);
            oasDocument.components.addSchemaDefinition(key, model);
            this.processSchema((OasSchema)model, (io.swagger.v3.oas.models.media.Schema)schema);
            this.addClassNameExtension((OasSchema)model, (String)key);
        });
        return oasDocument.components.getSchemaDefinitions();
    }

    private List<? extends OasSchema> readClassOas20(Oas20Document oasDocument, Class<?> clazz) {
        String name = clazz.getName();
        if (!name.contains(".")) {
            return null;
        }
        if (oasDocument.definitions == null) {
            oasDocument.definitions = oasDocument.createDefinitions();
        }
        Map swaggerModel = ModelConverters.getInstance().readAll(clazz);
        swaggerModel.forEach((key, schema) -> {
            Oas20SchemaDefinition model = oasDocument.definitions.createSchemaDefinition(key);
            oasDocument.definitions.addDefinition(key, model);
            this.processSchema((OasSchema)model, (io.swagger.v3.oas.models.media.Schema)schema);
            this.addClassNameExtension((OasSchema)model, (String)key);
        });
        return oasDocument.definitions.getDefinitions();
    }

    private void processSchema(OasSchema model, io.swagger.v3.oas.models.media.Schema schema) {
        Object example;
        String description;
        String type;
        model.type = type = schema.getType();
        model.format = schema.getFormat();
        String ref = schema.get$ref();
        if (ref != null) {
            model.$ref = model instanceof Oas20Schema ? "#/definitions/" + ref.substring("#/components/schemas/".length()) : ref;
        }
        if (type != null) {
            switch (type) {
                case "object": {
                    if (schema.getProperties() == null) break;
                    schema.getProperties().forEach((p, v) -> {
                        OasSchema property = (OasSchema)model.createPropertySchema((String)p);
                        model.addProperty((String)p, (Schema)property);
                        this.processSchema(property, (io.swagger.v3.oas.models.media.Schema)v);
                    });
                    break;
                }
                case "array": {
                    io.swagger.v3.oas.models.media.Schema items = ((ArraySchema)schema).getItems();
                    OasSchema modelItems = model.createItemsSchema();
                    model.items = modelItems;
                    this.processSchema(modelItems, items);
                    break;
                }
                case "string": {
                    if (schema.getEnum() == null) break;
                    model.enum_ = new ArrayList(schema.getEnum());
                    break;
                }
                case "number": 
                case "integer": {
                    break;
                }
                default: {
                    LOG.warn("Encountered unexpected type {} in processing schema.", (Object)type);
                }
            }
        }
        if (schema.getRequired() != null) {
            model.required = new ArrayList(schema.getRequired());
        }
        if ((description = schema.getDescription()) != null) {
            model.description = description;
        }
        if ((example = schema.getExample()) != null) {
            model.example = example;
        }
        if (schema.getAdditionalProperties() instanceof io.swagger.v3.oas.models.media.Schema) {
            OasSchema additionalProperties = model.createAdditionalPropertiesSchema();
            model.additionalProperties = additionalProperties;
            this.processSchema(additionalProperties, (io.swagger.v3.oas.models.media.Schema)schema.getAdditionalProperties());
        }
        if (schema.getExtensions() != null) {
            schema.getExtensions().forEach((key, value) -> {
                Extension extension = model.createExtension();
                extension.name = (String)key;
                extension.value = value;
            });
        }
    }

    private void addClassNameExtension(OasSchema schema, String name) {
        Extension extension = schema.createExtension();
        extension.name = "x-className";
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("type", "string");
        value.put("format", name);
        extension.value = value;
        schema.addExtension("x-className", extension);
    }

    static {
        MODEL_CONVERTERS.addConverter((ModelConverter)new FqnModelResolver());
    }

    private static class FqnModelResolver
    extends ModelResolver {
        public FqnModelResolver() {
            this(new ObjectMapper());
        }

        public FqnModelResolver(ObjectMapper mapper) {
            super(mapper);
            this._typeNameResolver.setUseFqn(true);
        }
    }
}

