/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.olingo4.Olingo4AppWrapper;
import org.apache.camel.component.olingo4.Olingo4Component;
import org.apache.camel.component.olingo4.Olingo4Configuration;
import org.apache.camel.component.olingo4.Olingo4Consumer;
import org.apache.camel.component.olingo4.Olingo4Producer;
import org.apache.camel.component.olingo4.internal.Olingo4ApiCollection;
import org.apache.camel.component.olingo4.internal.Olingo4ApiName;
import org.apache.camel.component.olingo4.internal.Olingo4Constants;
import org.apache.camel.component.olingo4.internal.Olingo4PropertiesHelper;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;
import org.apache.camel.util.CaseInsensitiveMap;

@UriEndpoint(firstVersion="2.19.0", scheme="olingo4", title="Olingo4", syntax="olingo4:apiName/methodName", apiSyntax="apiName/methodName", category={Category.CLOUD}, headersClass=Olingo4Constants.class)
public class Olingo4Endpoint
extends AbstractApiEndpoint<Olingo4ApiName, Olingo4Configuration>
implements EndpointServiceLocation {
    protected static final String RESOURCE_PATH_PROPERTY = "resourcePath";
    protected static final String RESPONSE_HANDLER_PROPERTY = "responseHandler";
    protected static final String SERVICE_URI_PROPERTY = "serviceUri";
    protected static final String FILTER_ALREADY_SEEN = "filterAlreadySeen";
    private static final String KEY_PREDICATE_PROPERTY = "keyPredicate";
    private static final String QUERY_PARAMS_PROPERTY = "queryParams";
    private static final String ENDPOINT_HTTP_HEADERS_PROPERTY = "endpointHttpHeaders";
    private static final String READ_METHOD = "read";
    private static final String EDM_PROPERTY = "edm";
    private static final String DATA_PROPERTY = "data";
    private static final String DELETE_METHOD = "delete";
    private static final String UREAD_METHOD = "uread";
    private Set<String> olingo4endpointPropertyNames;
    @UriParam
    private Olingo4Configuration configuration;
    private Olingo4AppWrapper apiProxy;

    public Olingo4Endpoint(String uri, Olingo4Component component, Olingo4ApiName apiName, String methodName, Olingo4Configuration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, Olingo4ApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public String getServiceUrl() {
        return this.configuration.getServiceUri();
    }

    public String getServiceProtocol() {
        return "odata";
    }

    public Producer createProducer() throws Exception {
        return new Olingo4Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        if (!READ_METHOD.equals(this.methodName) && !UREAD_METHOD.equals(this.methodName)) {
            throw new IllegalArgumentException("Only read method is supported for consumer endpoints");
        }
        Olingo4Consumer consumer = new Olingo4Consumer(this, processor);
        consumer.setSplitResult(this.configuration.isSplitResult());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<Olingo4Configuration> getPropertiesHelper() {
        return Olingo4PropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelOlingo4";
    }

    public void configureProperties(Map<String, Object> options) {
        CaseInsensitiveMap query = new CaseInsensitiveMap();
        CaseInsensitiveMap known = new CaseInsensitiveMap();
        options.forEach((arg_0, arg_1) -> Olingo4Endpoint.lambda$configureProperties$0((Map)query, (Map)known, arg_0, arg_1));
        options.keySet().removeIf(((Map)known)::containsKey);
        PropertyConfigurer configurer = this.getComponent().getEndpointPropertyConfigurer();
        if (configurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)configurer;
            for (String name : getter.getAllOptions((Object)this).keySet()) {
                if (!known.containsKey(name)) continue;
                Object value = known.get(name);
                boolean hit = configurer.configure(this.getCamelContext(), (Object)this, name, value, true);
                if (!hit) continue;
                known.remove(name);
            }
        }
        if ((configurer = PluginHelper.getConfigurerResolver((CamelContext)this.getCamelContext()).resolvePropertyConfigurer(this.configuration.getClass().getName(), this.getCamelContext())) != null) {
            PropertyBindingSupport.build().withConfigurer(configurer).withIgnoreCase(true).withTarget((Object)this.configuration).withCamelContext(this.getCamelContext()).withProperties((Map)known).withRemoveParameters(true).bind();
        }
        super.configureProperties((Map)known);
        if (!known.isEmpty()) {
            query.putAll(known);
        }
        options.keySet().removeIf(((Map)query)::containsKey);
        this.parseQueryParams((Map<String, Object>)query);
        options.putAll((Map<String, Object>)query);
    }

    protected void afterConfigureProperties() {
        this.olingo4endpointPropertyNames = new HashSet<String>(this.getPropertiesHelper().getValidEndpointProperties(this.getCamelContext(), (Object)this.configuration));
        this.olingo4endpointPropertyNames.add(EDM_PROPERTY);
        this.olingo4endpointPropertyNames.add(ENDPOINT_HTTP_HEADERS_PROPERTY);
        this.olingo4endpointPropertyNames.add(SERVICE_URI_PROPERTY);
        this.olingo4endpointPropertyNames.add(FILTER_ALREADY_SEEN);
        if (!(READ_METHOD.equals(this.methodName) || DELETE_METHOD.equals(this.methodName) || UREAD_METHOD.equals(this.methodName) || this.inBody != null)) {
            this.inBody = DATA_PROPERTY;
        }
        this.createProxy();
    }

    public synchronized Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy.getOlingo4App();
    }

    public Olingo4Component getComponent() {
        return (Olingo4Component)super.getComponent();
    }

    protected void doStart() throws Exception {
        if (this.apiProxy == null) {
            this.createProxy();
        }
    }

    protected void doStop() throws Exception {
        if (this.apiProxy != null) {
            this.getComponent().closeApiProxy(this.apiProxy);
            this.apiProxy = null;
        }
    }

    public void interceptPropertyNames(Set<String> propertyNames) {
        if (!DELETE_METHOD.equals(this.methodName)) {
            propertyNames.add(EDM_PROPERTY);
        }
        propertyNames.add(RESPONSE_HANDLER_PROPERTY);
    }

    public void interceptProperties(Map<String, Object> properties) {
        Map endpointHttpHeaders = (Map)properties.get(ENDPOINT_HTTP_HEADERS_PROPERTY);
        properties.put(EDM_PROPERTY, this.apiProxy.getEdm(endpointHttpHeaders));
        properties.put(FILTER_ALREADY_SEEN, this.configuration.isFilterAlreadySeen());
        String keyPredicate = (String)properties.get(KEY_PREDICATE_PROPERTY);
        if (keyPredicate != null) {
            properties.compute(RESOURCE_PATH_PROPERTY, (key, resourcePath) -> {
                if (resourcePath == null) {
                    throw new IllegalArgumentException("Resource path must be provided in endpoint URI, or URI parameter 'resourcePath', or exchange header 'CamelOlingo4.resourcePath'");
                }
                return String.valueOf(resourcePath) + "(" + keyPredicate + ")";
            });
        }
        this.parseQueryParams(properties);
    }

    private void createProxy() {
        this.apiProxy = this.getComponent().createApiProxy((Olingo4Configuration)this.getConfiguration());
    }

    private void parseQueryParams(Map<String, Object> options) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        Iterator<Map.Entry<String, Object>> it = options.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String paramName = entry.getKey();
            if (paramName.startsWith("consumer.") || this.olingo4endpointPropertyNames.contains(paramName)) continue;
            Object value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Null value for query parameter " + paramName);
            }
            queryParams.put(paramName, value.toString());
            it.remove();
        }
        if (!queryParams.isEmpty()) {
            Map oldParams = (Map)options.get(QUERY_PARAMS_PROPERTY);
            if (oldParams == null) {
                options.put(QUERY_PARAMS_PROPERTY, queryParams);
            } else {
                oldParams.putAll(queryParams);
            }
        }
    }

    private static /* synthetic */ void lambda$configureProperties$0(Map query, Map known, String k, Object v) {
        if (k.startsWith("$")) {
            query.put(k, v);
        } else {
            known.put(k, v);
        }
    }
}

