/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ognl;

import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.impl.ExpressionSupport;
import org.apache.camel.language.ExpressionEvaluationException;
import org.apache.camel.language.IllegalSyntaxException;
import org.apache.camel.language.ognl.OgnlLanguage;
import org.apache.camel.language.ognl.RootObject;
import org.apache.camel.spi.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlExpression
extends ExpressionSupport<Exchange> {
    private final String expressionString;
    private final Class<?> type;
    private Object expression;

    public OgnlExpression(OgnlLanguage language, String expressionString, Class<?> type) {
        this.expressionString = expressionString;
        this.type = type;
        try {
            this.expression = Ognl.parseExpression((String)expressionString);
        }
        catch (OgnlException e) {
            throw new IllegalSyntaxException((Language)language, expressionString);
        }
    }

    public static OgnlExpression ognl(String expression) {
        return new OgnlExpression(new OgnlLanguage(), expression, Object.class);
    }

    public Object evaluate(Exchange exchange) {
        OgnlContext oglContext = new OgnlContext();
        try {
            return Ognl.getValue((Object)this.expression, (Map)oglContext, (Object)new RootObject(exchange));
        }
        catch (OgnlException e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }
}

