/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth.jakarta;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.nimbusds.jose.jwk.JWKSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.camel.CamelContext;
import org.apache.camel.oauth.AuthCodeCredentials;
import org.apache.camel.oauth.ClientCredentials;
import org.apache.camel.oauth.Credentials;
import org.apache.camel.oauth.JWTOptions;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthCodeFlowParams;
import org.apache.camel.oauth.OAuthConfig;
import org.apache.camel.oauth.OAuthException;
import org.apache.camel.oauth.OAuthFlowType;
import org.apache.camel.oauth.OAuthLogoutParams;
import org.apache.camel.oauth.OAuthProperties;
import org.apache.camel.oauth.TokenCredentials;
import org.apache.camel.oauth.UserCredentials;
import org.apache.camel.oauth.UserProfile;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

public class ServletOAuth
extends OAuth {
    @Override
    public void discoverOAuthConfig(CamelContext ctx) throws OAuthException {
        if (this.config == null) {
            String baseUri = OAuthProperties.getRequiredProperty(ctx, "camel.oauth.base-uri");
            String clientId = OAuthProperties.getRequiredProperty(ctx, "camel.oauth.client-id");
            String clientSecret = OAuthProperties.getRequiredProperty(ctx, "camel.oauth.client-secret");
            OAuthConfig config = new OAuthConfig().setBaseUrl(baseUri).setClientId(clientId).setClientSecret(clientSecret);
            String wellKnownUri = baseUri + "/.well-known/openid-configuration";
            try {
                String jwksPath;
                String content = Request.get((String)wellKnownUri).execute().returnContent().asString();
                JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
                config.setAuthorizationPath(json.get("authorization_endpoint").getAsString()).setTokenPath(json.get("token_endpoint").getAsString()).setRevocationPath(json.get("revocation_endpoint").getAsString()).setLogoutPath(json.get("end_session_endpoint").getAsString()).setUserInfoPath(json.get("userinfo_endpoint").getAsString()).setIntrospectionPath(json.get("introspection_endpoint").getAsString()).setJwksPath(json.get("jwks_uri").getAsString());
                if (json.has("issuer")) {
                    JWTOptions jwtOptions = config.getJWTOptions();
                    jwtOptions.setIssuer(json.get("issuer").getAsString());
                }
                if (!(jwksPath = config.getJwksPath()).isBlank()) {
                    config.setJWKSet(JWKSet.load((URL)URI.create(jwksPath).toURL()));
                }
            }
            catch (Exception ex) {
                throw new OAuthException("Cannot discover OAuth config from: " + wellKnownUri, ex);
            }
            this.config = config;
        }
    }

    @Override
    public String buildCodeFlowAuthRequestUrl(OAuthCodeFlowParams params) {
        if (params.getScopes() == null) {
            params.setScope("openid");
        }
        if (params.getResponseType() == null) {
            params.setResponseType(OAuthCodeFlowParams.AuthRequestResponseType.CODE);
        }
        if (params.getClientId() == null) {
            params.setClientId(this.config.getClientId());
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(this.config.getAuthorizationPath());
            uriBuilder.addParameter("flow", OAuthFlowType.AUTH_CODE.getGrantType());
            uriBuilder.addParameter("scope", String.join((CharSequence)" ", params.getScopes()));
            uriBuilder.addParameter("response_type", params.getResponseType().toString().toLowerCase());
            uriBuilder.addParameter("client_id", params.getClientId());
            uriBuilder.addParameter("redirect_uri", params.getRedirectUri());
            String requestUrl = uriBuilder.build().toString();
            return requestUrl;
        }
        catch (URISyntaxException ex) {
            throw new OAuthException(ex);
        }
    }

    @Override
    public UserProfile authenticate(Credentials creds) throws OAuthException {
        UserProfile userProfile;
        block6: {
            try {
                if (creds instanceof UserCredentials) {
                    UserCredentials params = (UserCredentials)creds;
                    userProfile = this.authenticateUserCredentials(params);
                    break block6;
                }
                if (creds instanceof AuthCodeCredentials) {
                    AuthCodeCredentials params = (AuthCodeCredentials)creds;
                    userProfile = this.authenticateAuthCodeCredentials(params);
                    break block6;
                }
                if (creds instanceof TokenCredentials) {
                    TokenCredentials params = (TokenCredentials)creds;
                    userProfile = this.authenticateTokenCredentials(params);
                    break block6;
                }
                if (creds instanceof ClientCredentials) {
                    ClientCredentials params = (ClientCredentials)creds;
                    userProfile = this.authenticateClientCredentials(params);
                    break block6;
                }
                throw new OAuthException("Unsupported creds: " + creds.getClass().getName());
            }
            catch (Exception ex) {
                throw new OAuthException("Authentication failed", ex);
            }
        }
        return userProfile;
    }

    @Override
    public String buildLogoutRequestUrl(OAuthLogoutParams params) {
        UserProfile userProfile = params.getUserProfile();
        try {
            URIBuilder uriBuilder = new URIBuilder(this.config.getLogoutPath());
            if (userProfile.idToken().isPresent()) {
                uriBuilder.addParameter("id_token_hint", userProfile.idToken().get());
            }
            if (params.getRedirectUri() != null) {
                uriBuilder.addParameter("post_logout_redirect_uri", params.getRedirectUri());
            }
            String endSessionURL = uriBuilder.build().toString();
            return endSessionURL;
        }
        catch (URISyntaxException ex) {
            throw new OAuthException(ex);
        }
    }

    private UserProfile authenticateAuthCodeCredentials(AuthCodeCredentials creds) throws Exception {
        if (creds.getCode() == null || creds.getCode().isBlank()) {
            throw new OAuthException("code cannot be null or empty");
        }
        if (creds.getRedirectUri() != null && creds.getRedirectUri().isBlank()) {
            throw new OAuthException("redirectUri cannot be null or empty");
        }
        String auth = this.config.getClientId() + ":" + this.config.getClientSecret();
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        String grantType = creds.getFlowType().getGrantType();
        String content = Request.post((String)this.config.getTokenPath()).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", "Basic " + encodedAuth).bodyForm(new NameValuePair[]{new BasicNameValuePair("grant_type", grantType), new BasicNameValuePair("code", creds.getCode()), new BasicNameValuePair("redirect_uri", creds.getRedirectUri())}).execute().returnContent().asString();
        JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
        return UserProfile.fromJson(this.config, json);
    }

    private UserProfile authenticateUserCredentials(UserCredentials creds) throws Exception {
        UserProfile userProfile = creds.getUserProfile();
        if (userProfile.expired() && userProfile.refreshToken().isPresent()) {
            String auth = this.config.getClientId() + ":" + this.config.getClientSecret();
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
            String refreshToken = userProfile.refreshToken().get();
            String content = Request.post((String)this.config.getIntrospectionPath()).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", "Basic " + encodedAuth).bodyForm(new NameValuePair[]{new BasicNameValuePair("grant_type", "refresh_token"), new BasicNameValuePair("token", refreshToken)}).execute().returnContent().asString();
            JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
            userProfile = UserProfile.fromJson(this.config, json);
        }
        if (userProfile.expired()) {
            throw new OAuthException("user access has expired");
        }
        return userProfile;
    }

    private UserProfile authenticateClientCredentials(ClientCredentials creds) throws Exception {
        String auth = creds.getClientId() + ":" + creds.getClientSecret();
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        String grantType = creds.getFlowType().getGrantType();
        String content = Request.post((String)this.config.getTokenPath()).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", "Basic " + encodedAuth).bodyForm(new NameValuePair[]{new BasicNameValuePair("grant_type", grantType)}).execute().returnContent().asString();
        JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
        return UserProfile.fromJson(this.config, json);
    }

    private UserProfile authenticateTokenCredentials(TokenCredentials creds) throws Exception {
        JsonObject auxObj = new JsonObject();
        auxObj.add("access_token", (JsonElement)new JsonPrimitive(creds.getToken()));
        UserProfile userProfile = UserProfile.fromJson(this.config, auxObj);
        if (userProfile.expired()) {
            String auth = this.config.getClientId() + ":" + this.config.getClientSecret();
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
            String content = Request.post((String)this.config.getIntrospectionPath()).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", "Basic " + encodedAuth).bodyForm(new NameValuePair[]{new BasicNameValuePair("token", creds.getToken())}).execute().returnContent().asString();
            JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
            userProfile = UserProfile.fromJson(this.config, json);
        }
        if (userProfile.expired()) {
            throw new OAuthException("user access has expired");
        }
        return userProfile;
    }
}

