/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.oauth.AbstractOAuthProcessor;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthCodeFlowParams;
import org.apache.camel.oauth.OAuthException;
import org.apache.camel.oauth.OAuthFactory;
import org.apache.camel.oauth.OAuthProperties;
import org.apache.camel.oauth.OAuthSession;
import org.apache.camel.oauth.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthCodeFlowProcessor
extends AbstractOAuthProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) {
        CamelContext context = exchange.getContext();
        Message msg = exchange.getMessage();
        this.logRequestHeaders(this.procName, msg);
        OAuth oauth = this.findOAuth(context).orElseGet(() -> {
            OAuthFactory factory = OAuthFactory.lookupFactory(context);
            return factory.createOAuth();
        });
        OAuthSession session = oauth.getOrCreateSession(exchange);
        if (session.getUserProfile().isPresent()) {
            UserProfile userProfile = session.removeUserProfile().orElseThrow();
            try {
                userProfile = this.authenticateExistingUserProfile(oauth, userProfile);
                session.putUserProfile(userProfile);
                return;
            }
            catch (OAuthException ex) {
                this.log.error("Failed to authenticate: {}", (Object)userProfile.subject(), (Object)ex);
            }
        }
        String postLoginUrl = this.getPostLoginUrl(msg);
        this.log.info("Register post login url: {}", (Object)postLoginUrl);
        session.putValue("OAuthPostLoginUrl", postLoginUrl);
        String redirectUri = OAuthProperties.getRequiredProperty(exchange.getContext(), "camel.oauth.redirect-uri");
        OAuthCodeFlowParams params = new OAuthCodeFlowParams().setRedirectUri(redirectUri);
        String authRequestUrl = oauth.buildCodeFlowAuthRequestUrl(params);
        this.sendRedirect(msg, authRequestUrl);
    }

    private String getPostLoginUrl(Message msg) {
        Object postLoginUrl;
        String xProto = (String)msg.getHeader("X-Forwarded-Proto", String.class);
        String xHost = (String)msg.getHeader("X-Forwarded-Host", String.class);
        Integer xPort = (Integer)msg.getHeader("X-Forwarded-Port", Integer.class);
        if (xProto != null && xHost != null) {
            String httpUri;
            postLoginUrl = xProto + "://" + xHost;
            if (xPort != null) {
                if (xProto.equals("https") && xPort != 443) {
                    postLoginUrl = (String)postLoginUrl + ":" + xPort;
                }
                if (xProto.equals("http") && xPort != 80) {
                    postLoginUrl = (String)postLoginUrl + ":" + xPort;
                }
            }
            if ((httpUri = (String)msg.getHeader("CamelHttpUri", String.class)) != null && !httpUri.isEmpty()) {
                postLoginUrl = (String)postLoginUrl + httpUri;
            }
        } else {
            postLoginUrl = (String)msg.getHeader("CamelHttpUrl", String.class);
        }
        return postLoginUrl;
    }
}

