/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthFactory;
import org.apache.camel.oauth.TokenCredentials;
import org.apache.camel.oauth.UserCredentials;
import org.apache.camel.oauth.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthProcessor
implements Processor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final String procName = this.getClass().getSimpleName();

    protected Optional<OAuth> findOAuth(CamelContext context) {
        return OAuthFactory.lookupFactory(context).findOAuth();
    }

    protected OAuth findOAuthOrThrow(CamelContext context) {
        return this.findOAuth(context).orElseThrow(() -> new NoSuchElementException("No OAuth"));
    }

    protected UserProfile authenticateExistingUserProfile(OAuth oauth, UserProfile userProfile) {
        if (userProfile.expired()) {
            UserCredentials creds = new UserCredentials(userProfile);
            userProfile = oauth.authenticate(creds);
            this.log.info("Refreshed {}", (Object)userProfile.subject());
            userProfile.logDetails();
        } else {
            TokenCredentials creds = new TokenCredentials(userProfile.accessToken().orElseThrow());
            UserProfile updProfile = oauth.authenticate(creds);
            userProfile.merge(updProfile);
            this.log.info("ReAuthenticated {}", (Object)userProfile.subject());
            userProfile.logDetails();
        }
        return userProfile;
    }

    protected void logRequestHeaders(String msgPrefix, Message msg) {
        this.log.debug("{} - Request headers ...", (Object)msgPrefix);
        msg.getHeaders().forEach((k, v) -> this.log.debug("   {}: {}", k, v));
    }

    protected void sendRedirect(Message msg, String redirectUrl) {
        this.log.debug("Redirect to: {}", (Object)redirectUrl);
        msg.setHeader("CamelHttpResponseCode", (Object)302);
        msg.setHeader("Location", (Object)redirectUrl);
        msg.setBody((Object)"");
    }
}

