/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.oauth.AbstractOAuthProcessor;
import org.apache.camel.oauth.OAuthLogoutParams;
import org.apache.camel.oauth.OAuthProperties;
import org.apache.camel.oauth.OAuthSession;
import org.apache.camel.oauth.UserProfile;

public class OAuthLogoutProcessor
extends AbstractOAuthProcessor {
    public void process(Exchange exchange) {
        CamelContext context = exchange.getContext();
        this.findOAuth(context).ifPresent(oauth -> {
            Optional<OAuthSession> maybeSession = oauth.getSession(exchange);
            maybeSession.flatMap(OAuthSession::removeUserProfile).ifPresent(user -> {
                String postLogoutUrl = OAuthProperties.getProperty(exchange.getContext(), "camel.oauth.logout.redirectUri").orElse(null);
                OAuthLogoutParams params = new OAuthLogoutParams().setRedirectUri(postLogoutUrl).setUser((UserProfile)user);
                String logoutUrl = oauth.buildLogoutRequestUrl(params);
                this.log.info("OAuth logout: {}", (Object)logoutUrl);
                exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)302);
                exchange.getMessage().setHeader("Location", (Object)logoutUrl);
                exchange.getMessage().setBody((Object)"");
            });
        });
    }
}

