/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.oauth.AbstractOAuthProcessor;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthCodeFlowParams;
import org.apache.camel.oauth.OAuthFactory;
import org.apache.camel.oauth.OAuthProperties;
import org.apache.camel.oauth.OAuthSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthCodeFlowProcessor
extends AbstractOAuthProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) {
        CamelContext context = exchange.getContext();
        Message msg = exchange.getMessage();
        this.logRequestHeaders(this.procName, msg);
        OAuth oauth = this.findOAuth(context).orElseGet(() -> {
            OAuthFactory factory = OAuthFactory.lookupFactory(context);
            return factory.createOAuth();
        });
        OAuthSession session = oauth.getSession(exchange).or(() -> Optional.of(oauth.createSession(exchange))).get();
        if (session.getUserProfile().isPresent()) {
            this.authenticateExistingUserProfile(oauth, session);
        }
        if (session.getUserProfile().isEmpty()) {
            String postLoginUrl = (String)msg.getHeader("CamelHttpUrl", String.class);
            session.putValue("OAuthPostLoginUrl", postLoginUrl);
            String redirectUri = OAuthProperties.getRequiredProperty(exchange.getContext(), "camel.oauth.redirectUri");
            OAuthCodeFlowParams params = new OAuthCodeFlowParams().setRedirectUri(redirectUri);
            String authRequestUrl = oauth.buildCodeFlowAuthRequestUrl(params);
            this.setSessionCookie(msg, session);
            this.sendRedirect(msg, authRequestUrl);
        }
        this.log.info("{} - Done", (Object)this.procName);
    }
}

