/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oauth;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.oauth.AbstractOAuthProcessor;
import org.apache.camel.oauth.ClientCredentials;
import org.apache.camel.oauth.OAuth;
import org.apache.camel.oauth.OAuthException;
import org.apache.camel.oauth.OAuthFactory;
import org.apache.camel.oauth.OAuthProperties;
import org.apache.camel.oauth.OAuthSession;
import org.apache.camel.oauth.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthClientCredentialsProcessor
extends AbstractOAuthProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void process(Exchange exchange) {
        CamelContext context = exchange.getContext();
        Message msg = exchange.getMessage();
        this.logRequestHeaders(this.procName, msg);
        OAuth oauth = this.findOAuth(context).orElseGet(() -> {
            OAuthFactory factory = OAuthFactory.lookupFactory(context);
            return factory.createOAuth();
        });
        OAuthSession session = oauth.getSession(exchange).or(() -> Optional.of(oauth.createSession(exchange))).get();
        if (session.getUserProfile().isPresent()) {
            this.authenticateExistingUserProfile(oauth, session);
        }
        if (session.getUserProfile().isEmpty()) {
            String clientId = OAuthProperties.getRequiredProperty(exchange.getContext(), "camel.oauth.clientId");
            String clientSecret = OAuthProperties.getRequiredProperty(exchange.getContext(), "camel.oauth.clientSecret");
            UserProfile userProfile2 = oauth.authenticate(new ClientCredentials().setClientSecret(clientSecret).setClientId(clientId));
            session.putUserProfile(userProfile2);
            userProfile2.logDetails("Authenticated");
        }
        session.getUserProfile().ifPresent(userProfile -> {
            String accessToken = userProfile.accessToken().orElseThrow(() -> new OAuthException("No access_token"));
            msg.setHeader("Authorization", (Object)("Bearer " + accessToken));
        });
        this.log.info("{} - Done", (Object)this.procName);
    }
}

