/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import java.util.NoSuchElementException;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedSingletonObjectPool<T>
implements ObjectPool<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SharedSingletonObjectPool.class);
    private final PoolableObjectFactory<T> factory;
    private volatile T t;

    public SharedSingletonObjectPool(PoolableObjectFactory<T> factory) {
        this.factory = factory;
    }

    public synchronized T borrowObject() throws Exception, NoSuchElementException, IllegalStateException {
        if (this.t != null && !this.factory.validateObject(this.t)) {
            this.invalidateObject(this.t);
            LOG.info("Recreating new connection as current connection is invalid: {}", this.t);
            this.t = null;
        }
        if (this.t == null) {
            this.t = this.factory.makeObject();
        }
        return this.t;
    }

    public void returnObject(T obj) throws Exception {
    }

    public void invalidateObject(T obj) throws Exception {
        this.t = null;
    }

    public void addObject() throws Exception, IllegalStateException, UnsupportedOperationException {
    }

    public int getNumIdle() throws UnsupportedOperationException {
        return 0;
    }

    public int getNumActive() throws UnsupportedOperationException {
        return 1;
    }

    public void clear() throws Exception, UnsupportedOperationException {
        this.t = null;
    }

    public void close() throws Exception {
        this.t = null;
    }

    public void setFactory(PoolableObjectFactory<T> factory) throws IllegalStateException, UnsupportedOperationException {
    }
}

