/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.math.BigInteger;
import java.security.Principal;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.netty4.NettyComponent;
import org.apache.camel.component.netty4.NettyConfiguration;
import org.apache.camel.component.netty4.NettyConsumer;
import org.apache.camel.component.netty4.NettyPayloadHelper;
import org.apache.camel.component.netty4.NettyProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.14.0", scheme="netty4", title="Netty4", syntax="netty4:protocol:host:port", consumerClass=NettyConsumer.class, label="networking,tcp,udp")
public class NettyEndpoint
extends DefaultEndpoint
implements AsyncEndpoint {
    @UriParam
    private NettyConfiguration configuration;
    @UriParam(label="advanced", javaType="org.apache.camel.component.netty4.NettyServerBootstrapConfiguration", description="To use a custom configured NettyServerBootstrapConfiguration for configuring this endpoint.")
    private Object bootstrapConfiguration;

    public NettyEndpoint(String endpointUri, NettyComponent component, NettyConfiguration configuration) {
        super(endpointUri, (Component)component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        NettyConsumer answer = new NettyConsumer(this, processor, this.configuration);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        NettyProducer answer = new NettyProducer(this, this.configuration);
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public Exchange createExchange(ChannelHandlerContext ctx, Object message) throws Exception {
        Exchange exchange = this.createExchange();
        this.updateMessageHeader(exchange.getIn(), ctx);
        NettyPayloadHelper.setIn(exchange, message);
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public NettyComponent getComponent() {
        return (NettyComponent)super.getComponent();
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    protected String createEndpointUri() {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        return "netty4:" + this.getConfiguration().getProtocol() + "://" + this.getConfiguration().getHost() + ":" + this.getConfiguration().getPort();
    }

    protected SSLSession getSSLSession(ChannelHandlerContext ctx) {
        SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
        SSLSession sslSession = null;
        if (sslHandler != null) {
            sslSession = sslHandler.engine().getSession();
        }
        return sslSession;
    }

    protected void updateMessageHeader(Message in, ChannelHandlerContext ctx) {
        in.setHeader("CamelNettyChannelHandlerContext", (Object)ctx);
        in.setHeader("CamelNettyRemoteAddress", (Object)ctx.channel().remoteAddress());
        in.setHeader("CamelNettyLocalAddress", (Object)ctx.channel().localAddress());
        if (this.configuration.isSsl()) {
            SSLSession sslSession = this.getSSLSession(ctx);
            in.setHeader("CamelNettySSLSession", (Object)sslSession);
            if (this.configuration.isSslClientCertHeaders()) {
                this.enrichWithClientCertInformation(sslSession, in);
            }
        }
    }

    protected void enrichWithClientCertInformation(SSLSession sslSession, Message message) {
        try {
            X509Certificate[] certificates = sslSession.getPeerCertificateChain();
            if (certificates != null && certificates.length > 0) {
                BigInteger serial;
                Principal issuer;
                X509Certificate cert = certificates[0];
                Principal subject = cert.getSubjectDN();
                if (subject != null) {
                    message.setHeader("CamelNettySSLClientCertSubjectName", (Object)subject.getName());
                }
                if ((issuer = cert.getIssuerDN()) != null) {
                    message.setHeader("CamelNettySSLClientCertIssuerName", (Object)issuer.getName());
                }
                if ((serial = cert.getSerialNumber()) != null) {
                    message.setHeader("CamelNettySSLClientCertSerialNumber", (Object)serial.toString());
                }
                message.setHeader("CamelNettySSLClientCertNotBefore", (Object)cert.getNotBefore());
                message.setHeader("CamelNettySSLClientCertNotAfter", (Object)cert.getNotAfter());
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            // empty catch block
        }
    }
}

