/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.camel.component.netty4.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty4.http.NettyHttpConsumer;
import org.apache.camel.component.netty4.http.handlers.HttpRestConsumerPath;
import org.apache.camel.component.netty4.http.handlers.HttpServerChannelHandler;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerMultiplexChannelHandler
extends SimpleChannelInboundHandler<Object>
implements HttpServerConsumerChannelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpConsumer.class);
    private static final AttributeKey<HttpServerChannelHandler> SERVER_HANDLER_KEY = AttributeKey.valueOf((String)"serverHandler");
    private final Set<HttpServerChannelHandler> consumers = new CopyOnWriteArraySet<HttpServerChannelHandler>();
    private int port;
    private String token;
    private int len;

    @Override
    public void init(int port) {
        this.port = port;
        this.token = ":" + port;
        this.len = this.token.length();
    }

    @Override
    public void addConsumer(NettyHttpConsumer consumer) {
        this.consumers.add(new HttpServerChannelHandler(consumer));
    }

    @Override
    public void removeConsumer(NettyHttpConsumer consumer) {
        for (HttpServerChannelHandler handler : this.consumers) {
            if (handler.getConsumer() != consumer) continue;
            this.consumers.remove((Object)handler);
        }
    }

    @Override
    public int consumers() {
        return this.consumers.size();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequest request = (HttpRequest)msg;
        LOG.debug("Message received: {}", (Object)request);
        HttpServerChannelHandler handler = this.getHandler(request, request.method().name());
        if (handler != null) {
            boolean isRestrictedToOptions;
            boolean bl = isRestrictedToOptions = handler.getConsumer().getEndpoint().getHttpMethodRestrict() != null && handler.getConsumer().getEndpoint().getHttpMethodRestrict().contains("OPTIONS");
            if ("OPTIONS".equals(request.method().name()) && !isRestrictedToOptions) {
                String allowedMethods = CamelServlet.METHODS.stream().filter(m -> this.isHttpMethodAllowed(request, (String)m)).collect(Collectors.joining(","));
                if (allowedMethods == null && handler.getConsumer().getEndpoint().getHttpMethodRestrict() != null) {
                    allowedMethods = handler.getConsumer().getEndpoint().getHttpMethodRestrict();
                }
                if (allowedMethods == null) {
                    allowedMethods = "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
                }
                if (!allowedMethods.contains("OPTIONS")) {
                    allowedMethods = allowedMethods + ",OPTIONS";
                }
                DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                response.headers().set("Content-Type", (Object)"text/plain");
                response.headers().set("Content-Length", (Object)0);
                response.headers().set("Allow", (Object)allowedMethods);
                ctx.writeAndFlush((Object)response);
                ctx.close();
            } else {
                Attribute attr = ctx.channel().attr(SERVER_HANDLER_KEY);
                attr.set((Object)handler);
                if (msg instanceof HttpContent) {
                    HttpContent httpContent = (HttpContent)msg;
                    httpContent.content().retain();
                }
                handler.channelRead(ctx, request);
            }
        } else {
            boolean hasAnyMethod = CamelServlet.METHODS.stream().anyMatch(m -> this.isHttpMethodAllowed(request, (String)m));
            DefaultHttpResponse response = null;
            response = hasAnyMethod ? new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED) : new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Attribute attr = ctx.channel().attr(SERVER_HANDLER_KEY);
        HttpServerChannelHandler handler = (HttpServerChannelHandler)((Object)attr.get());
        if (handler != null) {
            handler.exceptionCaught(ctx, cause);
        } else {
            if (cause instanceof ClosedChannelException) {
                LOG.debug("Channel already closed. Ignoring this exception.");
                return;
            }
            LOG.warn("HttpServerChannelHandler is not found as attachment to handle exception, send 404 back to the client.", cause);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)0);
            ctx.writeAndFlush((Object)response);
            ctx.close();
        }
    }

    private boolean isHttpMethodAllowed(HttpRequest request, String method) {
        return this.getHandler(request, method) != null;
    }

    private HttpServerChannelHandler getHandler(HttpRequest request, String method) {
        HttpServerChannelHandler answer = null;
        if (method == null) {
            return null;
        }
        String path = request.uri();
        int idx = path.indexOf(this.token);
        if (idx > -1) {
            path = path.substring(idx + this.len);
        }
        path = HttpServerMultiplexChannelHandler.pathAsKey(path);
        ArrayList<HttpRestConsumerPath> paths = new ArrayList<HttpRestConsumerPath>();
        for (HttpServerChannelHandler handler : this.consumers) {
            paths.add(new HttpRestConsumerPath(handler));
        }
        RestConsumerContextPathMatcher.ConsumerPath best = RestConsumerContextPathMatcher.matchBestPath((String)method, (String)path, paths);
        if (best != null) {
            answer = (HttpServerChannelHandler)((Object)best.getConsumer());
        }
        List<Object> candidates = new ArrayList();
        if (answer == null) {
            for (HttpServerChannelHandler handler : this.consumers) {
                boolean matchOnUriPrefix;
                NettyHttpConsumer consumer = handler.getConsumer();
                String consumerPath = consumer.getConfiguration().getPath();
                if (!RestConsumerContextPathMatcher.matchPath((String)path, (String)consumerPath, (boolean)(matchOnUriPrefix = consumer.getEndpoint().getConfiguration().isMatchOnUriPrefix()))) continue;
                candidates.add((Object)handler);
            }
        }
        if ((candidates = candidates.stream().filter(c -> HttpServerMultiplexChannelHandler.matchRestMethod(method, c.getConsumer().getEndpoint().getHttpMethodRestrict())).collect(Collectors.toList())).size() == 1) {
            answer = (HttpServerChannelHandler)((Object)candidates.get(0));
        }
        return answer;
    }

    private static String pathAsKey(String path) {
        int idx;
        if (path == null || path.equals("/")) {
            path = "";
        }
        if ((idx = path.indexOf(63)) > -1) {
            path = path.substring(0, idx);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return UnsafeUriCharactersEncoder.encodeHttpURI((String)path);
    }

    private static boolean matchRestMethod(String method, String restrict) {
        return restrict == null || restrict.toLowerCase(Locale.ENGLISH).contains(method.toLowerCase(Locale.ENGLISH));
    }
}

