/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.http;

import io.netty.handler.codec.http.FullHttpRequest;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty4.http.DefaultNettyHttpBinding;
import org.apache.camel.component.netty4.http.NettyHttpConfiguration;
import org.apache.camel.component.netty4.http.NettyHttpHelper;
import org.apache.camel.spi.HeaderFilterStrategy;

public class RestNettyHttpBinding
extends DefaultNettyHttpBinding {
    public RestNettyHttpBinding() {
    }

    public RestNettyHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        super(headerFilterStrategy);
    }

    @Override
    public RestNettyHttpBinding copy() {
        try {
            return (RestNettyHttpBinding)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public void populateCamelHeaders(FullHttpRequest request, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        super.populateCamelHeaders(request, headers, exchange, configuration);
        String path = request.uri();
        if (path == null) {
            return;
        }
        URI uri = new URI(path);
        path = uri.getPath();
        String consumerPath = configuration.getPath();
        if (this.useRestMatching(consumerPath)) {
            String[] paths = path.split("/");
            String[] consumerPaths = consumerPath.split("/");
            for (int i = 0; i < consumerPaths.length && paths.length >= i; ++i) {
                String p1 = consumerPaths[i];
                if (!p1.startsWith("{") || !p1.endsWith("}")) continue;
                String key = p1.substring(1, p1.length() - 1);
                String value = paths[i];
                if (value == null) continue;
                NettyHttpHelper.appendHeader(headers, key, value);
            }
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

