/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.TimeoutMap;
import org.apache.camel.component.netty.NettyCamelState;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.DefaultTimeoutMap;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeoutCorrelationManagerSupport
extends ServiceSupport
implements CamelContextAware,
NettyCamelStateCorrelationManager {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutCorrelationManagerSupport.class);
    private volatile ScheduledExecutorService scheduledExecutorService;
    private volatile boolean stopScheduledExecutorService;
    private volatile ExecutorService workerPool;
    private volatile boolean stopWorkerPool;
    private volatile TimeoutMap<String, NettyCamelState> map;
    private volatile CamelLogger timeoutLogger;
    private CamelContext camelContext;
    private long timeout = 30000L;
    private long timeoutChecker = 1000L;
    private LoggingLevel timeoutLoggingLevel = LoggingLevel.DEBUG;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeoutChecker() {
        return this.timeoutChecker;
    }

    public void setTimeoutChecker(long timeoutChecker) {
        this.timeoutChecker = timeoutChecker;
    }

    public LoggingLevel getTimeoutLoggingLevel() {
        return this.timeoutLoggingLevel;
    }

    public void setTimeoutLoggingLevel(LoggingLevel timeoutLoggingLevel) {
        this.timeoutLoggingLevel = timeoutLoggingLevel;
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }

    public abstract String getRequestCorrelationId(Object var1);

    public abstract String getResponseCorrelationId(Object var1);

    public String getTimeoutResponse(String correlationId, Object request) {
        return null;
    }

    @Override
    public void putState(Channel channel, NettyCamelState state) {
        Object body = state.getExchange().getMessage().getBody();
        String cid = this.getRequestCorrelationId(body);
        if (ObjectHelper.isEmpty((String)cid)) {
            throw new IllegalArgumentException("CorrelationID is missing");
        }
        LOG.debug("putState({}) on channel: {}", (Object)cid, (Object)channel.id());
        this.map.put((Object)cid, (Object)state, this.timeout);
    }

    @Override
    public void removeState(ChannelHandlerContext ctx, Channel channel) {
    }

    @Override
    public NettyCamelState getState(ChannelHandlerContext ctx, Channel channel, Object msg) {
        String cid = this.getResponseCorrelationId(msg);
        if (ObjectHelper.isEmpty((String)cid)) {
            LOG.warn("CorrelationID is missing from response message.");
            return null;
        }
        LOG.debug("getState({}) on channel: {}", (Object)cid, (Object)channel.id());
        return (NettyCamelState)this.map.remove((Object)cid);
    }

    @Override
    public NettyCamelState getState(ChannelHandlerContext ctx, Channel channel, Throwable cause) {
        return null;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)this);
        this.timeoutLogger = new CamelLogger(LOG, this.timeoutLoggingLevel);
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "NettyTimeoutCorrelationManager");
            this.stopScheduledExecutorService = true;
        }
        if (this.workerPool == null) {
            this.workerPool = this.camelContext.getExecutorServiceManager().newDefaultThreadPool((Object)this, "NettyTimeoutWorkerPool");
            this.stopWorkerPool = true;
        }
        this.map = new DefaultTimeoutMap(this.scheduledExecutorService, this.timeoutChecker);
        this.map.addListener(this::onEviction);
        ServiceHelper.startService(this.map);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.map);
        if (this.scheduledExecutorService != null && this.stopScheduledExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdown((ExecutorService)this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
        if (this.workerPool != null && this.stopWorkerPool) {
            this.camelContext.getExecutorServiceManager().shutdown(this.workerPool);
            this.workerPool = null;
        }
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.map);
        if (this.scheduledExecutorService != null && this.stopScheduledExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdown((ExecutorService)this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
        if (this.workerPool != null && this.stopWorkerPool) {
            this.camelContext.getExecutorServiceManager().shutdown(this.workerPool);
            this.workerPool = null;
        }
    }

    private void onEviction(TimeoutMap.Listener.Type type, String key, NettyCamelState value) {
        if (type != TimeoutMap.Listener.Type.Evict) {
            return;
        }
        this.timeoutLogger.log("Timeout of correlation id: " + key);
        this.workerPool.submit(() -> {
            Exchange exchange = value.getExchange();
            AsyncCallback callback = value.getCallback();
            if (exchange != null && callback != null) {
                String timeoutBody = this.getTimeoutResponse(key, exchange.getMessage().getBody());
                if (timeoutBody != null) {
                    exchange.getMessage().setBody((Object)timeoutBody);
                } else {
                    exchange.setException((Throwable)new ExchangeTimedOutException(exchange, this.timeout));
                }
                callback.done(false);
            }
        });
    }
}

