/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.ObjectInput;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.netty.NettyConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.w3c.dom.Document;

@DeferredContextBinding
public final class NettyConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        NettyConverterLoader.addTypeConverter(registry, byte[].class, ByteBuf.class, false, (type, exchange, value) -> {
            byte[] answer = NettyConverter.toByteArray((ByteBuf)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, ByteBuf.class, byte[].class, false, (type, exchange, value) -> {
            ByteBuf answer = NettyConverter.toByteBuffer((byte[])value);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, ByteBuf.class, String.class, false, (type, exchange, value) -> {
            ByteBuf answer = NettyConverter.toByteBuffer((String)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, InputStream.class, ByteBuf.class, false, (type, exchange, value) -> {
            InputStream answer = NettyConverter.toInputStream((ByteBuf)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, ObjectInput.class, ByteBuf.class, false, (type, exchange, value) -> {
            ObjectInput answer = NettyConverter.toObjectInput((ByteBuf)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, String.class, ByteBuf.class, false, (type, exchange, value) -> {
            String answer = NettyConverter.toString((ByteBuf)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, DOMSource.class, ByteBuf.class, false, (type, exchange, value) -> {
            DOMSource answer = NettyConverter.toDOMSource((ByteBuf)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, SAXSource.class, ByteBuf.class, false, (type, exchange, value) -> {
            SAXSource answer = NettyConverter.toSAXSource((ByteBuf)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, StAXSource.class, ByteBuf.class, false, (type, exchange, value) -> {
            StAXSource answer = NettyConverter.toStAXSource((ByteBuf)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, StreamSource.class, ByteBuf.class, false, (type, exchange, value) -> {
            StreamSource answer = NettyConverter.toStreamSource((ByteBuf)value, exchange);
            return answer;
        });
        NettyConverterLoader.addTypeConverter(registry, Document.class, ByteBuf.class, false, (type, exchange, value) -> {
            Document answer = NettyConverter.toDocument((ByteBuf)value, exchange);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

