/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.serialization.ClassResolver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.apache.camel.component.netty.codec.ObjectDecoder;

public class DatagramPacketObjectDecoder
extends MessageToMessageDecoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private final ObjectDecoder delegateDecoder;

    public DatagramPacketObjectDecoder(ClassResolver resolver) {
        this.delegateDecoder = new ObjectDecoder(resolver);
    }

    protected void decode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof ByteBuf) {
            ByteBuf payload = (ByteBuf)msg.content();
            Object result = this.delegateDecoder.decode(ctx, payload);
            DefaultAddressedEnvelope addressedEnvelop = new DefaultAddressedEnvelope(result, (SocketAddress)((InetSocketAddress)msg.recipient()), (SocketAddress)((InetSocketAddress)msg.sender()));
            out.add(addressedEnvelop);
        }
    }
}

