/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;

public final class NettyCamelState {
    private final Exchange exchange;
    private final AsyncCallback callback;
    private final AtomicBoolean callbackCalled;

    public NettyCamelState(AsyncCallback callback, Exchange exchange) {
        this.callback = callback;
        this.exchange = exchange;
        this.callbackCalled = new AtomicBoolean();
    }

    public AsyncCallback getCallback() {
        return this.callback;
    }

    public boolean isDone() {
        return this.callbackCalled.get();
    }

    public void callbackDoneOnce(boolean doneSync) {
        if (!this.callbackCalled.getAndSet(true)) {
            this.callback.done(doneSync);
        }
    }

    public Exchange getExchange() {
        return this.exchange;
    }
}

