/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.camel.component.netty.codec.DelegateByteArrayDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DatagramPacketByteArrayDecoder
extends MessageToMessageDecoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private static final Logger LOG = LoggerFactory.getLogger(DatagramPacketByteArrayDecoder.class);
    private DelegateByteArrayDecoder delegateDecoder = new DelegateByteArrayDecoder();

    protected void decode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof ByteBuf) {
            this.delegateDecoder.decode(ctx, (ByteBuf)msg.content(), out);
            byte[] content = (byte[])out.remove(out.size() - 1);
            DefaultAddressedEnvelope addressedEnvelop = new DefaultAddressedEnvelope((Object)content, msg.recipient(), msg.sender());
            out.add(addressedEnvelop);
        } else {
            LOG.debug("Ignoring message content as it is not an io.netty.buffer.ByteBuf instance.");
        }
    }
}

