/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.neo4j.transformer;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import java.util.UUID;
import org.apache.camel.Message;
import org.apache.camel.component.neo4j.Neo4jEmbedding;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="neo4j:embeddings", description="Prepares the message to become an object writable by Neo4j component")
public class Neo4jEmbeddingDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Embedding embedding = (Embedding)message.getHeader("CamelLangChain4jEmbeddingsVector", Embedding.class);
        TextSegment text = (TextSegment)message.getBody(TextSegment.class);
        String id = (String)message.getHeader("CamelNeo4jVectorEmbeddingId", () -> UUID.randomUUID(), String.class);
        Neo4jEmbedding neo4jEmbedding = new Neo4jEmbedding(id, text.text(), embedding.vector());
        message.setBody((Object)neo4jEmbedding);
    }
}

