/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import io.nats.client.Options;
import io.nats.client.api.ConsumerConfiguration;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class NatsConfiguration {
    @UriPath
    @Metadata(required=true)
    private String topic;
    @UriParam(label="common")
    private String servers;
    @UriParam(label="advanced")
    private Connection connection;
    @UriParam(label="common", defaultValue="true")
    private boolean reconnect = true;
    @UriParam(label="common", defaultValue="2000")
    private int reconnectTimeWait = 2000;
    @UriParam(label="common")
    private boolean pedantic;
    @UriParam
    private boolean verbose;
    @UriParam(defaultValue="60")
    private int maxReconnectAttempts = 60;
    @UriParam(defaultValue="120000")
    private int pingInterval = 120000;
    @UriParam(label="common", defaultValue="2000")
    private int connectionTimeout = 2000;
    @UriParam(label="common", defaultValue="2")
    private int maxPingsOut = 2;
    @UriParam(label="common", defaultValue="5000")
    private int requestCleanupInterval = 5000;
    @UriParam(label="producer", defaultValue="20000")
    private long requestTimeout = 20000L;
    @UriParam(label="producer")
    private String replySubject;
    @UriParam
    private boolean noRandomizeServers;
    @UriParam
    private boolean noEcho;
    @UriParam(label="consumer")
    private String queueName;
    @UriParam(label="consumer")
    private boolean replyToDisabled;
    @UriParam(label="consumer")
    private String maxMessages;
    @UriParam(label="consumer", defaultValue="10")
    private int poolSize = 10;
    @UriParam(label="common", defaultValue="true")
    private boolean flushConnection = true;
    @UriParam(label="common", defaultValue="1000")
    private int flushTimeout = 1000;
    @UriParam(label="security")
    private boolean secure;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="security")
    String credentialsFilePath;
    @UriParam(label="advanced")
    private boolean traceConnection;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy = new DefaultHeaderFilterStrategy();
    @UriParam(label="common", defaultValue="false")
    private boolean jetstreamEnabled = false;
    @UriParam(label="common")
    private String jetstreamName;
    @UriParam(label="advanced", defaultValue="true")
    private boolean jetstreamAsync = true;
    @UriParam(label="advanced")
    private ConsumerConfiguration consumerConfiguration;
    @UriParam(label="advanced", defaultValue="true")
    private boolean pullSubscription = true;
    @UriParam(label="advanced")
    private String durableName;

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getReconnectTimeWait() {
        return this.reconnectTimeWait;
    }

    public void setReconnectTimeWait(int reconnectTimeWait) {
        this.reconnectTimeWait = reconnectTimeWait;
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public void setMaxReconnectAttempts(int maxReconnectAttempts) {
        this.maxReconnectAttempts = maxReconnectAttempts;
    }

    public int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public void setMaxPingsOut(int maxPingsOut) {
        this.maxPingsOut = maxPingsOut;
    }

    public int getRequestCleanupInterval() {
        return this.requestCleanupInterval;
    }

    public void setRequestCleanupInterval(int requestCleanupInterval) {
        this.requestCleanupInterval = requestCleanupInterval;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getReplySubject() {
        return this.replySubject;
    }

    public void setReplySubject(String replySubject) {
        this.replySubject = replySubject;
    }

    public boolean isNoRandomizeServers() {
        return this.noRandomizeServers;
    }

    public void setNoRandomizeServers(boolean noRandomizeServers) {
        this.noRandomizeServers = noRandomizeServers;
    }

    public boolean isNoEcho() {
        return this.noEcho;
    }

    public void setNoEcho(boolean noEcho) {
        this.noEcho = noEcho;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public boolean isReplyToDisabled() {
        return this.replyToDisabled;
    }

    public void setReplyToDisabled(boolean replyToDisabled) {
        this.replyToDisabled = replyToDisabled;
    }

    public String getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(String maxMessages) {
        this.maxMessages = maxMessages;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public boolean isFlushConnection() {
        return this.flushConnection;
    }

    public void setFlushConnection(boolean flushConnection) {
        this.flushConnection = flushConnection;
    }

    public int getFlushTimeout() {
        return this.flushTimeout;
    }

    public void setFlushTimeout(int flushTimeout) {
        this.flushTimeout = flushTimeout;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getCredentialsFilePath() {
        return this.credentialsFilePath;
    }

    public void setCredentialsFilePath(String credentialsFilePath) {
        this.credentialsFilePath = credentialsFilePath;
    }

    public Options.Builder createOptions() throws NoSuchAlgorithmException, IllegalArgumentException {
        Options.Builder builder = new Options.Builder();
        builder.server(this.splitServers());
        if (this.isVerbose()) {
            builder.verbose();
        }
        if (this.isTraceConnection()) {
            builder.traceConnection();
        }
        if (this.isPedantic()) {
            builder.pedantic();
        }
        if (this.isSecure()) {
            builder.secure();
        }
        if (!this.isReconnect()) {
            builder.noReconnect();
        } else {
            builder.maxReconnects(this.getMaxReconnectAttempts());
            builder.reconnectWait(Duration.ofMillis(this.getReconnectTimeWait()));
        }
        builder.pingInterval(Duration.ofMillis(this.getPingInterval()));
        builder.connectionTimeout(Duration.ofMillis(this.getConnectionTimeout()));
        builder.maxPingsOut(this.getMaxPingsOut());
        builder.requestCleanupInterval(Duration.ofMillis(this.getRequestCleanupInterval()));
        if (this.isNoRandomizeServers()) {
            builder.noRandomize();
        }
        if (this.isNoEcho()) {
            builder.noEcho();
        }
        return builder;
    }

    protected String splitServers() {
        StringBuilder servers = new StringBuilder();
        String prefix = "nats://";
        String srvspec = this.getServers();
        ObjectHelper.notNull((Object)srvspec, (String)"Servers");
        String[] pieces = srvspec.split(",");
        for (int i = 0; i < pieces.length; ++i) {
            if (i < pieces.length - 1) {
                if (pieces[i].contains("://")) {
                    servers.append(pieces[i]).append(',');
                    continue;
                }
                servers.append(prefix).append(pieces[i]).append(',');
                continue;
            }
            if (pieces[i].contains("://")) {
                servers.append(pieces[i]);
                continue;
            }
            servers.append(prefix).append(pieces[i]);
        }
        return servers.toString();
    }

    public boolean isTraceConnection() {
        return this.traceConnection;
    }

    public void setTraceConnection(boolean traceConnection) {
        this.traceConnection = traceConnection;
    }

    public boolean isJetstreamEnabled() {
        return this.jetstreamEnabled;
    }

    public void setJetstreamEnabled(boolean jetstreamEnabled) {
        this.jetstreamEnabled = jetstreamEnabled;
    }

    public String getJetstreamName() {
        return this.jetstreamName;
    }

    public void setJetstreamName(String jetstreamName) {
        this.jetstreamName = jetstreamName;
    }

    public boolean isJetstreamAsync() {
        return this.jetstreamAsync;
    }

    public void setJetstreamAsync(boolean jetstreamAsync) {
        this.jetstreamAsync = jetstreamAsync;
    }

    public ConsumerConfiguration getConsumerConfiguration() {
        return this.consumerConfiguration;
    }

    public void setConsumerConfiguration(ConsumerConfiguration consumerConfiguration) {
        this.consumerConfiguration = consumerConfiguration;
    }

    public boolean isPullSubscription() {
        return this.pullSubscription;
    }

    public void setPullSubscription(boolean pullSubscription) {
        this.pullSubscription = pullSubscription;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }
}

