/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class NatsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topic";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "nats".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "topic", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(31);
        props.add("bridgeErrorHandler");
        props.add("connection");
        props.add("connectionTimeout");
        props.add("credentialsFilePath");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("flushConnection");
        props.add("flushTimeout");
        props.add("headerFilterStrategy");
        props.add("lazyStartProducer");
        props.add("maxMessages");
        props.add("maxPingsOut");
        props.add("maxReconnectAttempts");
        props.add("noEcho");
        props.add("noRandomizeServers");
        props.add("pedantic");
        props.add("pingInterval");
        props.add("poolSize");
        props.add("queueName");
        props.add("reconnect");
        props.add("reconnectTimeWait");
        props.add("replySubject");
        props.add("replyToDisabled");
        props.add("requestCleanupInterval");
        props.add("requestTimeout");
        props.add("secure");
        props.add("servers");
        props.add("sslContextParameters");
        props.add("topic");
        props.add("traceConnection");
        props.add("verbose");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

