/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.mybatis.MyBatisEndpoint;
import org.apache.camel.component.mybatis.StatementType;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MyBatisProducer.class);
    private String statement;
    private MyBatisEndpoint endpoint;

    public MyBatisProducer(MyBatisEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.statement = endpoint.getStatement();
    }

    public void process(Exchange exchange) throws Exception {
        ExecutorType executorType = this.endpoint.getExecutorType();
        try (SqlSession session = executorType == null ? this.endpoint.getSqlSessionFactory().openSession() : this.endpoint.getSqlSessionFactory().openSession(executorType);){
            switch (this.endpoint.getStatementType()) {
                case SelectOne: {
                    this.doSelectOne(exchange, session);
                    break;
                }
                case SelectList: {
                    this.doSelectList(exchange, session);
                    break;
                }
                case Insert: {
                    this.doInsert(exchange, session);
                    break;
                }
                case InsertList: {
                    this.doInsertList(exchange, session);
                    break;
                }
                case Update: {
                    this.doUpdate(exchange, session);
                    break;
                }
                case UpdateList: {
                    this.doUpdateList(exchange, session);
                    break;
                }
                case Delete: {
                    this.doDelete(exchange, session);
                    break;
                }
                case DeleteList: {
                    this.doDeleteList(exchange, session);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported statementType: " + String.valueOf((Object)this.endpoint.getStatementType()));
                }
            }
            session.commit();
        }
    }

    private void doSelectOne(Exchange exchange, SqlSession session) {
        Object result;
        Object in = this.getInput(exchange);
        if (in != null) {
            LOG.trace("SelectOne: {} using statement: {}", in, (Object)this.statement);
            result = session.selectOne(this.statement, in);
        } else {
            LOG.trace("SelectOne using statement: {}", (Object)this.statement);
            result = session.selectOne(this.statement);
        }
        this.doProcessResult(exchange, result, session);
    }

    private void doSelectList(Exchange exchange, SqlSession session) {
        List result;
        Object in = this.getInput(exchange);
        if (in != null) {
            LOG.trace("SelectList: {} using statement: {}", in, (Object)this.statement);
            result = session.selectList(this.statement, in);
        } else {
            LOG.trace("SelectList using statement: {}", (Object)this.statement);
            result = session.selectList(this.statement);
        }
        this.doProcessResult(exchange, result, session);
    }

    private void doInsert(Exchange exchange, SqlSession session) {
        Object in = this.getInput(exchange);
        if (in != null) {
            Iterator<Object> iter = in instanceof Map ? Collections.singletonList(in).iterator() : ObjectHelper.createIterator((Object)in);
            while (iter.hasNext()) {
                Object value = iter.next();
                LOG.trace("Inserting: {} using statement: {}", value, (Object)this.statement);
                Integer result = session.insert(this.statement, value);
                this.doProcessResult(exchange, result, session);
            }
        } else {
            LOG.trace("Inserting using statement: {}", (Object)this.statement);
            Integer result = session.insert(this.statement);
            this.doProcessResult(exchange, result, session);
        }
    }

    private void doInsertList(Exchange exchange, SqlSession session) {
        Object in = this.getInput(exchange);
        if (in != null) {
            LOG.trace("Inserting: {} using statement: {}", in, (Object)this.statement);
            Integer result = session.insert(this.statement, in);
            this.doProcessResult(exchange, result, session);
        } else {
            LOG.trace("Inserting using statement: {}", (Object)this.statement);
            Integer result = session.insert(this.statement);
            this.doProcessResult(exchange, result, session);
        }
    }

    private void doUpdate(Exchange exchange, SqlSession session) {
        Object in = this.getInput(exchange);
        if (in != null) {
            Iterator<Object> iter = in instanceof Map ? Collections.singletonList(in).iterator() : ObjectHelper.createIterator((Object)in);
            while (iter.hasNext()) {
                Object value = iter.next();
                LOG.trace("Updating: {} using statement: {}", value, (Object)this.statement);
                Integer result = session.update(this.statement, value);
                this.doProcessResult(exchange, result, session);
            }
        } else {
            LOG.trace("Updating using statement: {}", (Object)this.statement);
            Integer result = session.update(this.statement);
            this.doProcessResult(exchange, result, session);
        }
    }

    private void doUpdateList(Exchange exchange, SqlSession session) {
        Object in = this.getInput(exchange);
        if (in != null) {
            LOG.trace("Updating: {} using statement: {}", in, (Object)this.statement);
            Integer result = session.update(this.statement, in);
            this.doProcessResult(exchange, result, session);
        } else {
            LOG.trace("Updating using statement: {}", (Object)this.statement);
            Integer result = session.update(this.statement);
            this.doProcessResult(exchange, result, session);
        }
    }

    private void doDelete(Exchange exchange, SqlSession session) {
        Object in = this.getInput(exchange);
        if (in != null) {
            Iterator<Object> iter = in instanceof Map ? Collections.singletonList(in).iterator() : ObjectHelper.createIterator((Object)in);
            while (iter.hasNext()) {
                Object value = iter.next();
                LOG.trace("Deleting: {} using statement: {}", value, (Object)this.statement);
                Integer result = session.delete(this.statement, value);
                this.doProcessResult(exchange, result, session);
            }
        } else {
            LOG.trace("Deleting using statement: {}", (Object)this.statement);
            Integer result = session.delete(this.statement);
            this.doProcessResult(exchange, result, session);
        }
    }

    private void doDeleteList(Exchange exchange, SqlSession session) {
        Object in = this.getInput(exchange);
        if (in != null) {
            LOG.trace("Deleting: {} using statement: {}", in, (Object)this.statement);
            Integer result = session.delete(this.statement, in);
            this.doProcessResult(exchange, result, session);
        } else {
            LOG.trace("Deleting using statement: {}", (Object)this.statement);
            Integer result = session.delete(this.statement);
            this.doProcessResult(exchange, result, session);
        }
    }

    private void doProcessResult(Exchange exchange, Object result, SqlSession session) {
        String outputHeader = this.getEndpoint().getOutputHeader();
        Message answer = exchange.getIn();
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            answer = exchange.getOut();
            answer.getHeaders().putAll(exchange.getIn().getHeaders());
            if (outputHeader != null) {
                answer.setBody(exchange.getIn().getBody());
            }
        }
        if (this.endpoint.getStatementType() == StatementType.SelectList || this.endpoint.getStatementType() == StatementType.SelectOne) {
            MappedStatement ms = session.getConfiguration().getMappedStatement(this.statement);
            if (ms != null && ms.getStatementType() == org.apache.ibatis.mapping.StatementType.CALLABLE) {
                if (result == null) {
                    LOG.trace("Setting result as existing body as MyBatis statement type is Callable, and there was no result.");
                    answer.setBody(exchange.getIn().getBody());
                } else if (outputHeader != null) {
                    LOG.trace("Setting result as header [{}]: {}", (Object)outputHeader, result);
                    answer.setHeader(outputHeader, result);
                } else {
                    LOG.trace("Setting result as body: {}", result);
                    answer.setBody(result);
                    answer.setHeader("CamelMyBatisResult", result);
                }
            } else if (outputHeader != null) {
                LOG.trace("Setting result as header [{}]: {}", (Object)outputHeader, result);
                answer.setHeader(outputHeader, result);
            } else {
                LOG.trace("Setting result as body: {}", result);
                answer.setBody(result);
                answer.setHeader("CamelMyBatisResult", result);
            }
        } else {
            String headerName = outputHeader != null ? outputHeader : "CamelMyBatisResult";
            answer.setHeader(headerName, result);
        }
        answer.setHeader("CamelMyBatisStatementName", (Object)this.statement);
    }

    public MyBatisEndpoint getEndpoint() {
        return (MyBatisEndpoint)super.getEndpoint();
    }

    private Object getInput(Exchange exchange) {
        String inputHeader = this.getEndpoint().getInputHeader();
        if (inputHeader != null) {
            return exchange.getIn().getHeader(inputHeader);
        }
        return exchange.getIn().getBody();
    }
}

