/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mybatis.BaseMyBatisEndpoint;
import org.apache.camel.component.mybatis.DefaultMyBatisProcessingStrategy;
import org.apache.camel.component.mybatis.MyBatisConsumer;
import org.apache.camel.component.mybatis.MyBatisProcessingStrategy;
import org.apache.camel.component.mybatis.MyBatisProducer;
import org.apache.camel.component.mybatis.StatementType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.7.0", scheme="mybatis", title="MyBatis", syntax="mybatis:statement", consumerClass=MyBatisConsumer.class, label="database,sql")
public class MyBatisEndpoint
extends BaseMyBatisEndpoint {
    @UriPath
    @Metadata(required="true")
    private String statement;
    @UriParam(label="producer")
    private StatementType statementType;
    @UriParam(label="consumer", description="Enables or disables transaction. If enabled then if processing an exchange failed then the consumerbreak out processing any further exchanges to cause a rollback eager.")
    private boolean transacted;
    @UriParam(label="consumer", defaultValue="0")
    private int maxMessagesPerPoll;
    @UriParam(label="consumer", optionalPrefix="consumer.")
    private String onConsume;
    @UriParam(label="consumer", optionalPrefix="consumer.", defaultValue="true")
    private boolean useIterator = true;
    @UriParam(label="consumer", optionalPrefix="consumer.")
    private boolean routeEmptyResultSet;
    @UriParam(label="consumer,advanced")
    private MyBatisProcessingStrategy processingStrategy = new DefaultMyBatisProcessingStrategy();

    public MyBatisEndpoint() {
    }

    public MyBatisEndpoint(String endpointUri, Component component, String statement) {
        super(endpointUri, component);
        this.statement = statement;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.statementType), (String)"statementType", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.statement, (String)"statement", (Object)((Object)this));
        return new MyBatisProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.statement, (String)"statement", (Object)((Object)this));
        MyBatisConsumer consumer = new MyBatisConsumer(this, processor);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setOnConsume(this.getOnConsume());
        consumer.setUseIterator(this.isUseIterator());
        consumer.setRouteEmptyResultSet(this.isRouteEmptyResultSet());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public MyBatisProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    public void setProcessingStrategy(MyBatisProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public String getOnConsume() {
        return this.onConsume;
    }

    public void setOnConsume(String onConsume) {
        this.onConsume = onConsume;
    }

    public boolean isUseIterator() {
        return this.useIterator;
    }

    public void setUseIterator(boolean useIterator) {
        this.useIterator = useIterator;
    }

    public boolean isRouteEmptyResultSet() {
        return this.routeEmptyResultSet;
    }

    public void setRouteEmptyResultSet(boolean routeEmptyResultSet) {
        this.routeEmptyResultSet = routeEmptyResultSet;
    }
}

